//***************************************************************
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Inc_C51b/rcs/LCD_DEF_LIB.h $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.1 $
// Datum:        $Date: 2001/02/03 09:55:44Z $
// Qualitt:     $State: Exp $
//***************************************************************
// Beschreibung: LCD_DEF.H Definitionen fuer den UART
//***************************************************************
// Historie:
//==========
// $Log: LCD_DEF_LIB.h $
// Revision 1.1  2001/02/03 09:55:44Z  MEBA
// Initial revision
//***************************************************************
#ifndef LCD_DEF_LIB_H
  #define LCD_DEF_LIB_H

//***************************************************************
// verwendete Definitionen
//***************************************************************
// allgemeine Definitionen
#define NODEF_LCD  0xFF
#define LCD_ADR    1     // LCD wird ueber Adrebus angesteuert
#define LCD_PORT   2     // LCD wird ueber Portpins angesteuert
#define LCD_I2C    3     // LCD wird ueber I2C-Bus  angesteuert
#define LCD_PIO    4     // LCD wird ueber I2C-Bus  angesteuert

#define _8BIT_BUS  0     // Datenbusbreite von der LCD
#define _4BIT_BUS  1

#define LOW_NIBBLE 0
#define HIGH_NIBBLE 1

#define LCD_INST   0
#define LCD_DATA   1

//***************************************************************
// Deklarationen von Funktionen und Variablen
//***************************************************************
/* Definitionen von Steuersignalen */
#define INIT_DISP   0x30    // Initsequenz fuer HD44780
#define INIT_8BIT   0x30
#define INIT_4BIT   0x20

#define LCD_WRITE 0
#define LCD_READ  1


#define LEFT   0                /* Richtungsangabe fuer die Funktionen: */
#define RIGHT  1                /* shift_it(), scroll_it()             */

#define CLS  0x01               /* Display loeschen */
#define HOME 0x02               /* Cursor an Adresse 0 im Display  */
#define LCD_BUSY 0x80

#define ENTRY      0x04         /* Setzt die Cursor-Richtung */
#define INCREMENT  0x02
#define DISP_SHIFT 0x01
#define DECREMENT  0x00


#define CONTROL      0x08       /* Setzt   Display  ON/ OFF */
#define DISPLAY_ON   0x04       /*         Cursor   ON/ OFF */
#define DISPLAY_OFF  0x00       /*         BLINK    ON/ OFF */
#define CURSOR_ON    0x02
#define CURSOR_OFF   0x00
#define BLINK        0x01
#define NO_BLINK     0x00

#define SHIFT      0x10         /* Bewegt den Cursor und schiebt */
#define SHI_LEFT   0x00         /* den Displayinhalt ohne den    */
#define SHI_RIGHT  0x04         /* Inhalt vom DD-RAM zu aendern.  */  
#define DIS_LEFT   0x08
#define DIS_RIGHT  0x0C

#define FUNCTION_SET 0x20       /* Setzt die Datenbreite, Zeilenanzahl */
                                /* und die Darstellung der Zeichen.    */
#define _8BIT        0x10       /* 8-bit Datenbus                      */
#define _4BIT        0x00       /* 4-bit Datenbus                      */
#define _2LINE       0x08       /* zweizeiliges Display                */
#define _1LINE       0x00       /* einzeiliges Display                 */ 
#define _10DOTS      0x04       /* 5*10 dots Aufloesung, je nach Displaytyp */
#define _7DOTS       0x00       /* 5*7  dots */

#define SET_CG_RAM   0x40       /* Setzt den Adresszaehler im CG-RAM   */       
#define CG_RAM       0x01
#define SET_DD_RAM   0x80       /* Setzt den Adresszaehler im DD-RAM   */
#define DD_RAM       0x00

#define ON  1
#define OFF 0

#endif
