//****************************************************************
// @doc
// @module INTELHEX.h | Enthlt Deklarationen und Definitionen fr 
// die Bearbeitung des Intelhex-Formats.
// @end
//----------------------------------------------------------------
// Definitionen fuer MKS  !!
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Inc_C51b/rcs/INTELHEX.H $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.1 $
// Datum:        $Date: 2001/02/03 09:55:43Z $
// Qualitt:     $State: Exp $
// Historie:
//==========
// $Log: INTELHEX.H $
// Revision 1.1  2001/02/03 09:55:43Z  MEBA
// Initial revision
//----------------------------------------------------------------

//***************************************************************
// Beschreibung:
//***************************************************************
//***************************************************************
// @type Definitionen | Definitionen und Deklarationen fr die 
// Auswertung des Intelhex-Formats.
//***************************************************************
#define NO_REC_MARK      0xFF // @define NO_REC_MARK      |
#define CHK_SUM_ERR      0xFE // @define CHK_SUM_ERR      |
#define NO_DEFINED_REC   0xFD // @define NO_DEFINED_REC   |
#define NO_ALLOWED_REC   0xFC // @define NO_ALLOWED_REC   |

#define ILLEGAL_AREA     0xE0 // @define ILLEGAL_AREA     |

#define DATA_REC         0x00 // @define DATA_REC         |
#define EOF_REC          0x01 // @define EOF_REC          |
#define EXT_SEG_ADDR_REC 0x02 // @define EXT_SEG_ADDR_REC |
#define STA_SEG_ADRR_REC 0x03 // @define STA_SEG_ADRR_REC |
#define EXT_LIN_ADDR_REC 0x04 // @define EXT_LIN_ADDR_REC |
#define STA_LIN_ADDR_REC 0x05 // @define STA_LIN_ADDR_REC |

//***************************************************************
// verwendete Include Dateien
//***************************************************************


//***************************************************************
// Deklarationen von Funktionen und Variablen
//***************************************************************

#ifndef INTEL_HEX_H
  #define INTEL_HEX_H

#include <makros.h>
extern union _24bit _24u;

// @func 
extern uchar ui_Read_Intelhex(uint uiStartAddr, uchar ucAreaSrc,
                                                uchar ucAreaDes); 
// @func 
extern uint ui_Create_Intelhex(uint uiStartAddr, 
                               uint uiAreaLength, uchar *pucPtrDes);					
  
#endif


