//***************************************************************
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Inc_C51b/rcs/I2c_Lib.h $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.2 $
// Datum:        $Date: 2001/06/10 10:06:00Z $
// Qualitt:     $State: Exp $
//***************************************************************
// Beschreibung: I2C_LIB.h
//***************************************************************
// Historie:
//==========
// $Log: I2c_Lib.h $
// Revision 1.2  2001/06/10 10:06:00Z  MEBA
// Die Abarbeitungsgeschwindigkeit eines Befehls im Derivat wird jetzt mit 
// beruecksichtigt.
// Revision 1.1  2001/06/10 10:04:46Z  MEBA
// Initial revision
//***************************************************************
#ifndef I2C_LIB_H
  #define I2C_LIB_H

//***************************************************************
// verwendete Definitionen
//***************************************************************
// Definition der Fehler
#define ERR_FUNK       0xF0
#define ERR_SEL        0x0F
#define ERR_SCL_SET    1
#define ERR_SCL_CLEAR  2
#define ERR_SDA_SET    3
#define ERR_SDA_CLEAR  4
#define ERR_ACK        5
#define ERR_START_I2C  0x10
#define ERR_STOP_I2C   0x20
#define ERR_WRITE_I2C  0x30
 
#define I2C_DEV   0 // wird fuer verschiedene Moeglich-
#define I2C_ADR   1 // keiten schreiben Device-Adr.,
#define I2C_DATA  2 // Daten-Adr und Daten benoetigt.
#define RE_START  3
#define ACK       0
#define NACK      1

#define READ_I2C  1
#define WRITE_I2C 0

//***************************************************************
// Definitionen von Zeit-Makros fr 100kHz-Uebertragung
//***************************************************************
#if (SYSTEM_CLK * MACHINE_CYCLE) <= 8 // MHz
 #define SCL_SET   do{ btSCL = SET;}   while(!btSCL); 
 #define SCL_CLEAR do{ btSCL = CLEAR;} while(btSCL);  
 #define SDA_CLEAR do{ btSDA = CLEAR;} while(btSDA); 

#elif (SYSTEM_CLK * MACHINE_CYCLE) > 8  && (SYSTEM_CLK * MACHINE_CYCLE) <= 12 // MHz
 #define SCL_SET   do{ btSCL = SET;}   while(!btSCL); _nop_() 
 #define SCL_CLEAR do{ btSCL = CLEAR;} while(btSCL);  
 #define SDA_CLEAR do{ btSDA = CLEAR;} while(btSDA);  _nop_()

#elif (SYSTEM_CLK * MACHINE_CYCLE) > 12  && (SYSTEM_CLK * MACHINE_CYCLE) <= 16 // MHz
 #define SCL_SET   do{ btSCL = SET;}   while(!btSCL); _nop_(); _nop_();_nop_() 
 #define SCL_CLEAR do{ btSCL = CLEAR;} while(btSCL);  _nop_()
 #define SDA_CLEAR do{ btSDA = CLEAR;} while(btSDA); _nop_(); _nop_(); _nop_()

#elif (SYSTEM_CLK * MACHINE_CYCLE) > 16  && (SYSTEM_CLK * MACHINE_CYCLE) <= 20 // MHz
 #define SCL_SET   do{ btSCL = SET;}   while(!btSCL); _nop_(); _nop_();_nop_(); _nop_();_nop_();_nop_() 
 #define SCL_CLEAR do{ btSCL = CLEAR;} while(btSCL);  _nop_(); _nop_();_nop_();_nop_()
 #define SDA_CLEAR do{ btSDA = CLEAR;} while(btSDA); _nop_(); _nop_(); _nop_(); _nop_();_nop_();_nop_()
#else
      #error Fehler_1001:                          
      #error   Fuer die angegebene SYSTEM_CLKHZ in GLOBALS.h sind
      #error   die Makros SCL_SET, SCL_CLEAR und SDA_CLEAR nicht definiert.
#endif

//***************************************************************
// Deklarationen von Funktionen und Variablen
//***************************************************************
uchar uc_StartI2C(void); // Erzeugen einer Startbedingung
uchar uc_StopI2C(void);  // Erzeugen einer Stoppbedingung
uchar uc_WriteI2C(uchar ucAddr, uchar ucValue); // Schreibt einen Wert
uchar uc_ReadI2C(bit btACK); // Liest einen Wert
uchar uc_I2C_Dev(uchar ucI2C_Dev); // Ueberprueft eine Adresse
// Funktionen zum Lesen bzw. Schreiben von Daten in einen Baustein
uchar uc_Data2I2C(uchar ucI2CDev, uchar ucI2CAddr, uchar *pucSrc);
uchar uc_I2C2Data(uchar ucI2CDev, uchar ucI2CAddr, uchar *pucDes);
// Funktionen zum Lesen bw. Schreiben von Daten aus einem IO-Baustein
uchar uc_IO2I2C(uchar ucI2CDev, uchar *pucDes);
uchar uc_I2C2IO(uchar ucI2CDev, uchar ucValue);
uchar uc_Data2I2C_EEPROM(uchar ucI2CDev, uchar ucI2CAddr, uchar *pucSrc);

#endif
