//****************************************************************
// @doc
// @module DEF_BITS.h | Enthlt Definitionen fr Bits in SFR-Registern
// von 8051-Derivaten die nicht bitadressierbar sind.
// @end
//----------------------------------------------------------------
// Definitionen fuer MKS  !!
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Inc_C51b/rcs/Def_bits.h $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.1 $
// Datum:        $Date: 2001/02/03 09:55:42Z $
// Qualitt:     $State: Exp $
// Historie:
//==========
// $Log: Def_bits.h $
// Revision 1.1  2001/02/03 09:55:42Z  MEBA
// Initial revision
//----------------------------------------------------------------

//***************************************************************
// Beschreibung: DEF_BITS.H
//***************************************************************
#ifndef DEF_BITS
  #define DEF_BITS

  #include<makros.h>
//***************************************************************
// @type Definitionen | Definitionen fr SFR-Bits in 8051-Derivaten
// die nicht bitadressierbar sind.
//***************************************************************
// globale Definitionen fuer alle Derivate 
// @define SFR PCON | Definitionen der Bits im SFR PCON 
    // Definitionen des SFRs PCON
      #define SMOD      B10000000 // @define SMOD |
      #define GF1       B00001000 // @define GF1  |
      #define GF0       B00000100 // @define GF0  |
      #define PD        B00000010 // @define PD   |
      #define IDL       B00000001 // @define IDL  |
// @define SFR TMOD | Definitionen der Bits im SFRs TMOD  
      #define GATE_1    B10000000 // @define GATE_1 |
      #define CT_1      B01000000 // @define CT_1   |
      #define M1_1      B00100000 // @define M1_1   |
      #define M0_1      B00010000 // @define M0_1   |
      #define GATE_0    B00001000 // @define GATE_0 |
      #define CT_0      B00000100 // @define CT_0   |
      #define M1_0      B00000010 // @define M1_0   |
      #define M0_0      B00000001 // @define M0_0   |
      #define _16BIT_0  B00000001 // @define _16BIT_0 |
      #define _16BIT_1  B00010000 // @define _16BIT_1 |
      #define _8BITREL1 B00100000 // @define _8BITREL1 |
      #define CLR_TIM0  B11110000 // @define CLR_TIM0  |
      #define CLR_TIM1  B00001111 // @define CLR_TIM1  |

 
    #if MIKROPRO == _8051FX 
    #elif MIKROPRO == _8032
    #elif MIKROPRO == _80515 || MIKROPRO == _80515A
    #elif MIKROPRO == _80517 || MIKROPRO == _80517A || MIKROPRO == _517 || MIKROPRO == _517A

// @define SFRs P6 (80C517(A)) | Definitionen der Bits im SFRs P6  
      #define ADST_  B00000001 // @define ADST_ |
      #define RXD1   B00000010 // @define RXD1  |
      #define TXD1   B00000100 // @define TXD1  |
    
// @define SFRs SYSCON (80C517(A)) | Definitionen der Bits im SFRs SYSCON  
      #define XMAP1  B00000010 // @define XMAP1 |
      #define XMAP0  B00000001 // @define XMAP0 |

// @define SFRs S1CON (80C517(A)) | Definitionen der Bits im SFRs S1CON  
      #define MODE      B11000000 // @define MODE      |
      #define _SHIFTREG B00000000 // @define _SHIFTREG |
      #define _8BIT_VAR B01000000 // @define _8BIT_VAR |
      #define _9BIT_FIX B10000000 // @define _9BIT_FIX |
      #define _9BIT_VAR B11000000 // @define _9BIT_VAR |
      #define SM21      B00100000 // @define SM21      |
      #define REN1      B00010000 // @define REN1      |
      #define TB81      B00001000 // @define TB81      |
      #define RB81      B00000100 // @define RB81      |
      #define TI1       B00000010 // @define TI1       |
      #define RI1       B00000001 // @define RI1       |

// @define SFRs PCON (80C517(A)) | Definitionen der Bits im SFRs PCON  
      #define PDS    B01000000 // @define PDS       |
      #define IDLS   B00100000 // @define IDLS      |
      #define SD     B00010000 // @define SD        |

// @define SFRs CTCON (80C517(A)) | Definitionen der Bits im SFRs CTCON  
      #define T2PS1  B10000000 // @define T2PS1     |
      #define CTF    B00001000 // @define CTF       |
      #define CLK2   B00000100 // @define CLK2      |
      #define CLK1   B00000010 // @define CLK1      |
      #define CLK0   B00000001 // @define CLK0      |

// @define SFRs CCEN (80C517(A)) | Definitionen der Bits im SFRs CCEN  
      #define CC3_DISABLE   B00000000 // @define CC3_DISABLE   |
      #define CC3_CAP_RISE  B01000000 // @define CC3_CAP_RISE  |
      #define CC3_COMPARE   B10000000 // @define CC3_COMPARE   |
      #define CC3_CAP_WRITE B11000000 // @define CC3_CAP_WRITE |

      #define CC2_DISABLE   B00000000 // @define CC2_DISABLE   |
      #define CC2_CAP_RISE  B00010000 // @define CC2_CAP_RISE  |
      #define CC2_COMPARE   B00100000 // @define CC2_COMPARE   |
      #define CC2_CAP_WRITE B00110000 // @define CC2_CAP_WRITE |

      #define CC1_DISABLE   B00000000 // @define CC1_DISABLE   |
      #define CC1_CAP_RISE  B00000100 // @define CC1_CAP_RISE  |
      #define CC1_COMPARE   B00001000 // @define CC1_COMPARE   |
      #define CC1_CAP_WRITE B00001100 // @define CC1_CAP_WRITE |

      #define CC0_DISABLE   B00000000 // @define CC0_DISABLE   |
      #define CC0_CAP_RISE  B00000001 // @define CC0_CAP_RISE  |
      #define CC0_COMPARE   B00000010 // @define CC0_COMPARE   |
      #define CC0_CAP_WRITE B00000011 // @define CC0_CAP_WRITE |

// @define SFRs CC4EN (80C517(A)) | Definitionen der Bits im SFRs CC4EN  
      #define CC4_DISABLE   B00000000 // @define CC4_DISABLE   |
      #define CC4_CAP_RISE  B00000010 // @define CC4_CAP_RISE  |
      #define CC4_COMPARE   B00000100 // @define CC4_COMPARE   |
      #define CC4_CAP_WRITE B00000110 // @define CC4_CAP_WRITE |
      #define COMO          B00000001 // @define COMO          |

// @define SFRs ARCON (80C517(A)) | Definitionen der Bits im SFRs ARCON  
      #define MDEF   B10000000 // @define MDEF          |
      #define MDOV   B01000000 // @define MDOV          |
      #define SLR    B00100000 // @define SLR           |

// @define SFRs IP0 (80C517(A)) | Definitionen der Bits im SFRs IP0  
      #define OWDS   B10000000 // @define OWDS          |
      #define WDTS   B01000000 // @define WDTS          |

// @define SFRs IEN2 (80C517(A)) | Definitionen der Bits im SFRs IEN2  
      #define ECT    B00001000 // @define ECT           |
      #define ES1    B00000001 // @define ES1           |


    #if MIKROPRO == _80517
// @define SFRs CC4EN (80C517) | Definitionen der Bits im SFRs CC4EN  
      #define COCOEN  B00001000 // @define COCOEN       |

    #endif
    #if MIKROPRO == _80517A
// @define SFRs CTCON (80C517A) | Definitionen der Bits im SFRs CTCON  
      #define ICR     B00100000 // @define ICR       |
      #define ICS     B00010000 // @define ICS       |

// @define SFRs ADCON1 (80C517A) | Definitionen der Bits im SFRs ADCON1  
      #define ADCL    B10000000 // @define ADCL      |

// @define SFRs CC4EN (80C517A) | Definitionen der Bits im SFRs CC4EN  
      #define COCOEN1 B10000000 // @define COCOEN1   |
      #define COCOEN0 B00001000 // @define COCOEN0   |

// @define SFRs IRCON1 (80C517A) | Definitionen der Bits im SFRs IRCON1  
      #define ICMP7   B10000000 // @define ICMP7     |
      #define ICMP6   B01000000 // @define ICMP6     |
      #define ICMP5   B00100000 // @define ICMP5     |
      #define ICMP4   B00010000 // @define ICMP4     |
      #define ICMP3   B00001000 // @define ICMP3     |
      #define ICMP2   B00000100 // @define ICMP2     |
      #define ICMP1   B00000010 // @define ICMP1     |
      #define ICMP0   B00000001 // @define ICMP0     |

// @define SFRs IEN2 (80C517A) | Definitionen der Bits im SFRs IEN2  
      #define ECR     B00100000 // @define ECR       |
      #define ECS     B00010000 // @define ECS       |
      #define ECMP    B00000100 // @define ECMP      |

    #endif
    #elif MIKROPRO == _80151
    #elif MIKROPRO == _80320
    #elif MIKROPRO == _80751 || _80781
    #elif MIKROPRO == 80552 
    #endif

#endif
