//****************************************************************
// @doc
// @module DEF_INT.h | Enthlt Definitionen fr Interruptquellen
// von 8051-Derivaten.
// @end
//----------------------------------------------------------------
// Definitionen fuer MKS  !!
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Inc_C51b/rcs/DEF_INT.H $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.1 $
// Datum:        $Date: 2001/02/03 09:55:43Z $
// Qualitt:     $State: Exp $
// Historie:
//==========
// $Log: DEF_INT.H $
// Revision 1.1  2001/02/03 09:55:43Z  MEBA
// Initial revision
//----------------------------------------------------------------

//***************************************************************
// Beschreibung: DEF_INT.H
// 03.09.2000 87LPC762 mit aufgenommen
//***************************************************************
#ifndef DEF_INT
  #define DEF_INT
//***************************************************************
// Definitionen der Interrupt- Nummern
//***************************************************************
// @type Interrupt-Definitionen 80C31/80C51| Interrupt-Definitionen
// fr den 80C31 und 80C51
//***************************************************************
  #define EXT_INT0        0 // @define EXT_INT0 | 0
  #define TIM_INT0        1 // @define TIM_INT0 | 1
  #define EXT_INT1        2 // @define EXT_INT1 | 2
  #define TIM_INT1        3 // @define TIM_INT1 | 3
  #define SER_INT0        4 // @define SER_INT0 | 4
//***************************************************************
// 
#if MIKROPRO == _8051FX 
// @type Interrupt-Definitionen 8051FX| Zustzliche Interrupt-Definitionen
// fr den 8051FX gelten.
  #define PCA_TIM_INT     6 // @define PCA_TIM_INT | 6

#elif MIKROPRO >= _8032
// @type Interrupt-Definitionen 80C32| Zustzliche Interrupt-Definitionen
// fr den 80C32 gelten.
  #define TIM_INT2        5 // @define TIM_INT2     | 5
  #define EXT_TIM2_INT    5 // @define EXT_TIM2_INT | 5

 #if MIKROPRO >= _80515 && MIKROPRO <= _80517A
// @type Interrupt-Definitionen 80C515(A), 80C517(A)| Zustzliche Interrupt-Definitionen
// die fr den 80C515(A), 80C517(A), 517(A) gemeinsam gelten.
   #define AD_INT         8 // @define AD_INT       | 8
   #define EXT_INT2       9 // @define EXT_INT2     | 9
   #define EXT_INT3      10 // @define EXT_INT3     | 10
   #define EXT_INT4      11 // @define EXT_INT4     | 11
   #define EXT_INT5      12 // @define EXT_INT5     | 12
   #define EXT_INT6      13 // @define EXT_INT6     | 13

   #if MIKROPRO >= _80517
// @type Interrupt-Definitionen 80C517(A)| Zustzliche Interrupt-Definitionen
// die fr den 80C517(A), 517(A) gemeinsam gelten.
     #define SER_INT1    16 // @define SER_INT1     | 16
     #define CMP_TIM_INT 19 // @define CMP_TIM_INT  | 19

    #if MIKROPRO == _80517A
// @type Interrupt-Definitionen 80C517A| Zustzliche Interrupt-Definitionen
// die fr den 80C517A, 517A gelten.
      #define CM_INT     18 // @define CM_INT       | 18
      #define SET_INT    20 // @define SET_INT      | 20
      #define CLR_INT    21 // @define CLR_INT      | 21 
    #endif
   #endif

 #elif MIKROPRO == _80151
// @type Interrupt-Definitionen 80151| Zustzliche Interrupt-Definitionen
// die fr den 80151 gelten.
   #define PCA_TIM_INT    6 // @define PCA_TIM_INT  | 6 

 #elif MIKROPRO == _80320
// @type Interrupt-Definitionen 80C320| Zustzliche Interrupt-Definitionen
// die fr den 80C320 gelten.
   #define PWR_FAIL_INT   6 // @define PWR_FAIL_INT | 6 
   #define SER_INT1       7 // @define SER_INT1     | 7 
   #define EXT_INT2       8 // @define EXT_INT2     | 8
   #define EXT_INT3       9 // @define EXT_INT3     | 9
   #define EXT_INT4      10 // @define EXT_INT4     | 10
   #define EXT_INT5      11 // @define EXT_INT5     | 11
   #define WATCHDOG_INT  12 // @define WATCHDOG_INT | 12
 #endif

#elif MIKROPRO == _80751 || _80781
// @type Interrupt-Definitionen 80751, 80781| Zustzliche Interrupt-Definitionen
// die fr den 80751 und 80781 gelten.
  #undef  SER_INT0
  #define I2C_INT        4 // @define I2C_INT       | 4

  #if MIKROPRO == _80781
// @type Interrupt-Definitionen 80781| Zustzliche Interrupt-Definitionen
// die fr den 80781 gelten.
    #define SER_INT0     5 // @define SER_INT0      | 5
    #define TIM_INT2     6 // @define TIM_INT2      | 6
    #define EXT_INT2     7 // @define EXT_INT2      | 7
    #define EXT_INT3     8 // @define EXT_INT3      | 8
    #define EXT_INT4     9 // @define EXT_INT4      | 9
    #define EXT_INT5    10 // @define EXT_INT5      | 10
    #define EXT_INT6    11 // @define EXT_INT6      | 11
    #define EXT_INT7    12 // @define EXT_INT7      | 12
    #define EXT_INT8    13 // @define EXT_INT8      | 13  
    #define EXT_INT9    14 // @define EXT_INT9      | 14
  #endif 
 #endif

#if MIKROPRO == _80552 
// @type Interrupt-Definitionen 80552| Zustzliche Interrupt-Definitionen
// die fr den 80552 gelten.
  #define I2C_INT        5 // @define I2C_INT       | 5
  #define CT_INT0        6 // @define CT_INT0       | 6
  #define CT_INT1        7 // @define CT_INT1       | 7
  #define CT_INT2        8 // @define CT_INT2       | 8
  #define CT_INT3        9 // @define CT_INT3       | 9
  #define AD_INT        10 // @define AD_INT        | 10
  #define CM_INT0       11 // @define CM_INT0       | 11
  #define CM_INT1       12 // @define CM_INT1       | 12
  #define CM_INT2       13 // @define CM_INT2       | 13
  #define TIM_INT2      14 // @define TIM_INT2      | 14

#elif MIKROPRO == _87LPC762
// @type Interrupt-Definitionen 87LPC762| Zustzliche Interrupt-Definitionen
// die fr den 87LPC762 gelten.
  #define BOD_INT        5 // @define BOD_INT       | 5
  #define ATN_INT        6 // @define ATN_INT       | 5
  #define KBF_INT        7 // @define KBF_INT       | 5
  #define CMF2_INT       8 // @define CMF2_INT      | 5
// Nummer  9 ist nicht belegt
  #define WDOVF_INT     10 // @define WDOVF_INT     | 5 
// Nummer 11 ist nicht belegt
  #define CMF1_INT      12 // @define CMF1_INT      | 5
// Nummer 13 ist nicht belegt
  #define TIMI_INT      14 // @define TIMI_INT      | 5 
#endif

#endif

