/*****************************************************************************/
/* Funktion: cg_ram.h         Date: 24.05.1992       User: MEBA (c) 1992     */
/* Beschreibung:                                                             */
/*****************************************************************************/

/* Deklarationen von Funktionen */

 /* Laden der definierten Zeichen in das CG-RAM */
extern uchar uc_Load_CGRam(uchar ucRAM_Adr, uchar *ucPtr);

/* Deklaration von Variablen */
extern bit btCG_Set;

/* Definition von verwendeten Sonderzeichen */

enum {
      // Aus arr_Lib.h                       
      ARR_L_B,  ARR_R_B,  ARR_U,    ARR_D,
      ARR_UL,   ARR_UR,   ARR_DL,   ARR_DR,
      // aus BEH1_LiB.H                      
      BEH1_FU,  BEH1_4L,  BEH1_3L,  BEH1_2L, 
      BEH1_1L,                               
      // Aus WALK_LiB.H                      
      WALK_1,   WALK_2,   WALK_3,   WALK_4,
      WALK_5,   WALK_6,   WALK_7,   WALK_8,
      // Aus BEH2_LiB.H                      
      BEH2_FU,  BEH2_4L,  BEH2_3L,  BEH2_2L, 
      BEH2_1L,  BEH2_EM,                    
      // Aus BEv1_LiB.H                      
      BEV1_FU,  BEV1_7D,  BEV1_6D,  BEV1_5D,  
      BEV1_4D,  BEV1_3D,  BEV1_2D,  BEV1_1D,
      // Aus BEV2_LiB.H                      
      BEV2_7D,  BEV2_6D,  BEV2_5D,  BEV2_4D,
      BEV2_3D,  BEV2_2D,  BEV2_1D,  BEV2_EM,
      BEV2_FU,
      // Aus SRCV_LIB.H
      SCRV_FU,  SCRV_1U,  SCRV_7D,  SCRV_6D,
      SCRV_5D,  SCRV_4D,  SCRV_3D,  SCRV_2D,
      SCRV_1D,
      // Aus SCRH_LIB.H
      SCRH_6H,  SCRH_5H,  SCRH_4H,  SCRH_3H,
      SCRH_2H,  SCRH_1H,
      // Aus CLK_LIB.H
      SIGN_1,   SIGN_2,   SIGN_3,   SIGN_4,
      SIGN_5,   SIGN_6,   SIGN_7,   SIGN_8,
      SIGN_9,   SIGN_10,  SIGN_11,  SIGN_12,
      SIGN_13,  SIGN_14,  SIGN_15,  SIGN_16,
      SIGN_17,  SIGN_18,  SIGN_19,  SIGN_20,
      SIGN_21,  SIGN_22,  SIGN_23,  SIGN_24,
      SIGN_25,  SIGN_26,  SIGN_27,  SIGN_28,
      SIGN_29,  SIGN_30,  SIGN_31          
};

#ifdef CG_RAM_MAIN

#include <arr_lib.h>
#include <beh1_lib.h>
#include <beh2_lib.h>
#include <bev1_lib.h>
#include <walk_lib.h>
#include <bev2_lib.h>
#include <scrv_lib.h>
#include <scrh_lib.h>
#include <clk_lib.h>

code uchar ucaCG_Ram[][8] = { 
      // Aus arr_lib.h                       
      ARR_L_B,  ARR_R_B,  ARR_U,    ARR_D,   
      ARR_UL,   ARR_UR,   ARR_DL,   ARR_DR,
      // Aus BEH1_lib.h                      
      BEH1_FU,  BEH1_4L,  BEH1_3L,  BEH1_2L, 
      BEH1_1L,                               
      // Aus walk_lib.h                      
      WALK_1,   WALK_2,   WALK_3,   WALK_4,
      WALK_5,   WALK_6,   WALK_7,   WALK_8,
      // Aus beh2_lib.h                      
      BEH2_FU,  BEH2_4L,  BEH2_3L,  BEH2_2L, 
      BEH2_1L,  BEH2_EM,                    
      // Aus bev1_lib.h                      
      BEV1_FU,  BEV1_7D,  BEV1_6D,  BEV1_5D,  
      BEV1_4D,  BEV1_3D,  BEV1_2D,  BEV1_1D,
      // Aus bev2_lib.h                      
      BEV2_7D,  BEV2_6D,  BEV2_5D,  BEV2_4D,
      BEV2_3D,  BEV2_2D,  BEV2_1D,  BEV2_EM,
      BEV2_FU,
      // Aus SRCV_LIB.H
      SCRV_FU, SCRV_1U,  SCRV_7D,  SCRV_6D,
      SCRV_5D,  SCRV_4D,  SCRV_3D,  SCRV_2D,
      SCRV_1D,
      // Aus SCRH_LIB.H
      SCRH_6H,  SCRH_5H,  SCRH_4H,  SCRH_3H,
      SCRH_2H,  SCRH_1H,
      // Aus CLK_LIB.H
      SIGN_1,   SIGN_2,   SIGN_3,   SIGN_4,
      SIGN_5,   SIGN_6,   SIGN_7,   SIGN_8,
      SIGN_9,   SIGN_10,  SIGN_11,  SIGN_12,
      SIGN_13,  SIGN_14,  SIGN_15,  SIGN_16,
      SIGN_17,  SIGN_18,  SIGN_19,  SIGN_20,
      SIGN_21,  SIGN_22,  SIGN_23,  SIGN_24,
      SIGN_25,  SIGN_26,  SIGN_27,  SIGN_28,
      SIGN_29,  SIGN_30,  SIGN_31          
};


#else
extern code uchar ucaCG_Ram[][8];
#endif
