// MD, vyhodena inicializacia PIO (8255???)
//     zrejme pristup cez pamat nie je podporovany simulatorom, overit...

//***************************************************************
// Modulname:    $Source: C:/c51_buecher/Teil2/software/LCD/LCD_Lib/rcs/Lcd_mat_Lib.c $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.1 $
// Datum:        $Date: 2001/02/03 10:50:22Z $
// Qualitaet:    $State: Exp $
//***************************************************************
// Beschreibung:
//***************************************************************
// Historie:
//==========
// $Log: Lcd_mat_Lib.c $
// Revision 1.1  2001/02/03 10:50:22Z  MEBA
// Initial revision
//***************************************************************
// Steuerparameter:
//***************************************************************
#pragma

//***************************************************************
// globale Definitionen
//***************************************************************
#define LCD_MAT_LIB_C

//***************************************************************
// verwendete Include Dateien
//***************************************************************

#include <defines.h>
#include <globals.h>
#include <time_out_lib.h>
// enthaelt allgemeine Einstellungen zum Projekt
#include <lcd_def.h>
#include <cg_ram_lib.h>


//***************************************************************
// Enthaelt zusaetzliche Definitionen fuer die Ansteuerung der LCD
// ueber IC-Bus.
//***************************************************************
#if (LCD_DEV == LCD_I2C)
 #include <i2c_def.h>
 #include <i2c_chip_lib.h>
 #include <i2c_lib.h>
#endif 

//***************************************************************
// Enthaelt zusaetzliche Definitionen fuer die Ansteuerung der LCD
// ueber PIO.
//***************************************************************
#if (LCD_DEV == LCD_PIO || LCD_DEV == LCD_ADR)
   bit btRS;
#endif



#if (LCD_DEV == LCD_PORT || LCD_DEV == LCD_I2C)
//***************************************************************
// Hier muessen die Anpassungen vorgenommen werden, wie das LCD
// an den PCF8574. PCF8575 angeschlossen ist.
//***************************************************************
bdata uchar ucPort;
sbit  sbD0  =ucPort ^ LCD_DEF_D4;
sbit  sbD1  =ucPort ^ LCD_DEF_D5;
sbit  sbD2  =ucPort ^ LCD_DEF_D6;
sbit  sbD3  =ucPort ^ LCD_DEF_D7;

sbit sbEN   = ucPort ^ LCD_DEF_EN;
sbit sbR_W  = ucPort ^ LCD_DEF_R_W;
sbit btRS   = ucPort ^ LCD_DEF_RS;
#endif


bit btLF = 0;
bit btRS_Old;
bit btID;
uchar ucDD_Adr;   // aktuelle Adresse

//***************************************************************
// Funktionsname uc_LCDIni() 
// Version: 1.0    Datum 
// Uebergabeparameter: ucLCD_Control
// Beschreibung: 
// Die Funktion uc_LCDIni initialisiert den HD44780-Controller
//***************************************************************
uchar uc_LCDIni(uchar ucLCD_Control){
 uchar ucError = OK;
 uchar ucData, ucStep;

// 1. Ueberpruefung ob das LCD ueber einen 4 bit-datenbus angesprochen
//    wird. In diesem Fall muessen die Initialisierungsdaten bei der
//    Verwendung der unteren 4 Datenbits ins untere Nibble kopiert werden.  
#if (LCD_DEV == LCD_PORT || LCD_DEV == LCD_I2C) && LCD_DATEN == _4BIT_BUS
  #if (LCD_NIBBLE == LOW_NIBBLE)
     ucData = INIT_DISP /16; // Daten ins untere Nibble schieben
  #else
     ucData = INIT_DISP;     // Daten im oberen Nibble belassen
  #endif

  #if (LCD_DEV == LCD_PORT)
    LCD_EN = LCD_R_W = LCD_RS = CLEAR; // Steuerport zuruecksetzen
  #endif
      sbR_W = LCD_WRITE;
#else
  ucData = INIT_DISP;
#endif

// 2. Initialisierung des LCD nach Datenblatt (siehe hierzu Seite 95, Teil 2). 
  btRS = LCD_INST;
  for (ucStep = 0; ucStep <3; ucStep++){

    #if LCD_DEV == LCD_PORT
  	  #if (LCD_NIBBLE == LOW_NIBBLE) 
        ucPort = ucData;
      #else
        ucPort = ucData;
      #endif
      EN_CLK;
    #elif LCD_DEV == LCD_ADR
      *WRITE_INS = ucData;
    #elif LCD_DEV == LCD_I2C
      ucPort = ucData;
      sbEN = SET;
      ucError = uc_I2C2IO( LCD_I2C_ADR, ucPort);
	  if (ucError) return(ucError);
      sbEN = CLEAR;
      ucError = uc_I2C2IO( LCD_I2C_ADR, ucPort);
	  if (ucError) return(ucError);
	#elif LCD_DEV == LCD_PIO
	// Setzen des Datenbytes an das LCD
	  stPIO.LCD_PIO_PORT.ucWrite = ucData;
      stPIO.ucControl = LCD_PIO_EN | SET_BIT_8255;
      stPIO.ucControl = LCD_PIO_EN | CLR_BIT_8255;
    #endif

   v_Wait(500);
  }

//***************************************************************
// Initialisierung ueber IC-Bus
//***************************************************************
#if LCD_DEV == LCD_I2C
  #if LCD_DATEN == _8BIT_BUS
    ucError = NODEF_LCD;
  #else
  #if (LCD_NIBBLE == LOW_NIBBLE) 
    ucPort = INIT_4BIT /16;
  #else
    ucPort = INIT_4BIT;
  #endif
    sbEN = SET;
    ucError = uc_I2C2IO( LCD_I2C_ADR, ucPort);
	  if (ucError) return(ucError);
    sbEN = CLEAR;
    ucError = uc_I2C2IO( LCD_I2C_ADR, ucPort);
	  if (ucError) return(ucError);
  #endif
#endif

//***************************************************************
// Initialisierung ueber Portpins
//***************************************************************
#if LCD_DEV == LCD_PORT
  #if LCD_DATEN == _8BIT_BUS
    ucError = NODEF_LCD;
  #else
  #if (LCD_NIBBLE == LOW_NIBBLE) 
    ucPort = INIT_4BIT / 16; // !! Nur gueltig wenn Datenport Px^0-Px^3
  #else
    ucPort = INIT_4BIT;        // !! Nur gueltig wenn Datenport Px^4-Px^7
  #endif
    EN_CLK;
   v_Wait(50); // Ab jetzt ist BF-Abfrage moeglich
  #endif
#endif

//***************************************************************
// Initialisierung ueber Adresse im XRAM
//***************************************************************
#if LCD_DEV == LCD_ADR
   #if LCD_BUS == _8BIT_BUS
     *WRITE_INS = INIT_8BIT;    // 8 Datenbit Busbreite 
   #else
     *WRITE_INS = INIT_4BIT;    // 4 Datenbit Busbreite  
     v_Wait(50);				// MD, zmenene men z wait ...
   #endif
#endif

//***************************************************************
// Initialisierung ueber PIO im XRAM
//***************************************************************

#if (0)  //MD
#if LCD_DEV == LCD_ADR
   #if LCD_BUS == _8BIT_BUS
     stPIO.LCD_PIO_PORT.ucWrite = INIT_8BIT; // 8 Datenbit Busbreite 
     stPIO.ucControl = LCD_PIO_EN | SET_BIT_8255;
     stPIO.ucControl = LCD_PIO_EN | CLR_BIT_8255;
   #else
     stPIO.LCD_PIO_PORT.ucWrite = INIT_4BIT; // 4 Datenbit Busbreite 
     stPIO.ucControl = LCD_PIO_EN | SET_BIT_8255;
     stPIO.ucControl = LCD_PIO_EN | CLR_BIT_8255;
   #endif
   wait(50);
#endif
#endif  //MD


//***************************************************************
// Bei erfolgreicher Initialisierung wird das Display aktiviert
//***************************************************************
if (ucError == OK) {
  btRS = LCD_INST;
 #if LCD_DATEN == _8BIT_BUS
  putchar(FUNCTION_SET | _8BIT | ucLCD_Control); v_Wait(200);
  putchar(FUNCTION_SET | _8BIT | ucLCD_Control);
 #else
  putchar(FUNCTION_SET | _4BIT | ucLCD_Control); v_Wait(200);
  putchar(FUNCTION_SET | _4BIT | ucLCD_Control);
 #endif
  putchar(CONTROL | DISPLAY_OFF);
  putchar(CONTROL | DISPLAY_ON | CURSOR_ON | BLINK);
  uc_Clrscr();
  putchar(ENTRY | INCREMENT);
  btID = INCREMENT >>1;
}
 btRS =LCD_DATA; // Umschalten auf Datenmodus
 return(ucError);
}


//***************************************************************
// Funktionsname uc_ReadData() 
// Version: 1.0    Datum 
// Uebergabeparameter: keine
// Beschreibung: 
// Funktion uc_ReadData() erlaubt Ihnen die Daten vom CG-RAM bzw.
// vom DD-RAM des HD44780 auszulesen. Je nach eingestellter    
// Adresse werden die Daten entweder vom DD-RAM oder CG-RAM    
// ausgelesen.                                                 
//***************************************************************
uchar uc_ReadData(void) {
  bit btRS_Bak;
  uchar erg_uc;

  btRS_Bak = btRS;
  btRS = LCD_DATA;
#if LCD_DEV == LCD_ADR
 erg_uc = *READ_DATA;
#elif LCD_DEV == LCD_PORT
  LCD_D4 = LCD_D5 = LCD_D6 = LCD_D7 = SET; // Datenport zum lesen freigeben
  LCD_R_W = LCD_READ;  // Instruktionen sollen vom HD44780 gelesen werdn
   LCD_RS = LCD_DATA;
    LCD_EN = SET; erg_uc = LCD_SFR & 0x0F; LCD_EN = CLEAR;
    erg_uc = erg_uc << 4;
    LCD_EN = SET; erg_uc = erg_uc | (LCD_SFR & 0x0F); LCD_EN = CLEAR;

#elif LCD_DEV == LCD_I2C
//  error:  noch nicht implementiert
#endif
  btRS = btRS_Bak;
  return(erg_uc);
}

//***************************************************************
// Funktionsname uc_ReadData() 
// Version: 1.0    Datum 
// Uebergabeparameter: ucInst
// Beschreibung: 
// Funktion uc_SetInst() erlaubt Ihnen die Register vom HD44780  
// einzeln zu beschreiben. Dabei wird das Steuerbit RS nach dem
// Schreiben einer Instruction in den alten Zustand zurueckge- 
// setzt.                                                      
//***************************************************************
uchar uc_SetInst(uchar ucInst){
  uchar ucError;
  bit btRS_Bak;

  // Abfrage der Cursorrichtung
  if ((ucInst & 0xFC) == ENTRY) {
    btID = (ucInst & 0x02) >> 1;
   }
  btRS_Bak = btRS;
  btRS = LCD_INST;
  ucError = putchar(ucInst);
  btRS = btRS_Bak;
  return(ucError);
}

//***************************************************************
// Funktionsname uc_Busy() 
// Version: 1.0    Datum 
// Uebergabeparameter: keine
// Beschreibung: 
// Funktion uc_Busy() wartet ab, bis der HD44780 das busy-Flag zu-
// rueckgesetzt hat.                                          
//***************************************************************
uchar uc_Busy(void) {

  uchar ucACAddress = 0x00;
#if LCD_DEV == LCD_ADR
  while (*READ_INS & 0x80);
#elif LCD_DEV == LCD_PORT
 bit btBsy;
  LCD_D4 = LCD_D5 = LCD_D6 = LCD_D7 = SET; // Datenport zum lesen freigeben
  LCD_R_W = LCD_READ;  // Instruktionen sollen vom HD44780 gelesen werdn
   LCD_RS = LCD_INST;
  do {
    LCD_EN = SET; 
	btBsy = LCD_D7; 
	if (LCD_D6) ucACAddress |= 0x40;
	if (LCD_D5) ucACAddress |= 0x20;
	if (LCD_D4) ucACAddress |= 0x10;
	LCD_EN = CLEAR;
    LCD_EN = SET; 
	if (LCD_D7) ucACAddress |= 0x08;
	if (LCD_D6) ucACAddress |= 0x04;
	if (LCD_D5) ucACAddress |= 0x02;
	if (LCD_D4) ucACAddress |= 0x01;
	LCD_EN = CLEAR;
  } while (btBsy == SET);  // btLF wird als Zwischenspeicher missbraucht

#elif LCD_DEV == LCD_I2C
  v_Wait(5);
#elif LCD_DEV == LCD_PIO
  stPIO.ucControl = PORT_A_IN | PORT_CH_OUT;
  stPIO.ucControl = LCD_PIO_RW | SET_BIT_8255;
  {
  bit btBusy;
  do{
    stPIO.ucControl = LCD_PIO_EN | SET_BIT_8255;
	 btBusy = stPIO.LCD_PIO_PORT.ucRead & LCD_BUSY;
    stPIO.ucControl = LCD_PIO_EN | CLR_BIT_8255;
  }
  while (btBusy); 
  }
  stPIO.ucControl = LCD_PIO_RW | CLR_BIT_8255;
  stPIO.ucControl = PORT_A_OUT | PORT_CH_OUT;
#endif
  return ucACAddress;
}

//***************************************************************
// Funktionsname uc_Clrscr() 
// Version: 1.0    Datum 
// Uebergabeparameter: keine
// Beschreibung: 
// Die Funktion uc_Clrscr() loescht den Inhalt vom DD-RAM und setzt
// den Cursor in die linke obere Ecke vom Display.              
//***************************************************************
uchar uc_Clrscr(void) {
  uchar ucError = OK;
  btRS_Old = btRS;
  btRS =LCD_INST;
  ucError = putchar( CLS );                // LCD loeschen 
#if LCD_DEV == LCD_I2C
  v_Wait(100);
#endif
  if (ucError == OK)
   ucError = putchar( HOME );
#if LCD_DEV == LCD_I2C
  v_Wait(100);
#endif
  btRS = btRS_Old;
  ucDD_Adr = 0;  // Bei Home wird der interne DD-Zeiger auf 0 
  return(ucError);
}

//***************************************************************
// Funktionsname putchar() 
// Version: 1.0    Datum 
// Uebergabeparameter: ucValue
// Beschreibung: 
// Die Funktion printf() verwendet zur Ausgabe von Zeichen     
// die Funktion putchar(). Diese ist als Source beim Kauf vom  
// C51-Compiler im PATH \inc vorhanden. Da die Funktion putchar
// nur einen Parameter uebergeben kann, werden Instruktionen mit
// Ausnahme von \n(Zeilenumbruch) separat durchgefuehrt.        
//***************************************************************
char putchar (uchar ucValue)  {

   if (ucValue == 0x0A && !btCG_Set && (btRS == LCD_DATA)) {   // \n wird von printf in 0x0A 
      btLF = ON; btRS = LCD_INST;                      // umgesetzt
   }
   else {
//***************************************************************
// Die Ausgabe erfolgt ueber eine Adresse im XRAM
//***************************************************************
#if LCD_DEV == LCD_ADR
     if (btLF == ON) {
       btRS = LCD_INST;
       ucDD_Adr = ucValue;
       ucValue = SET_DD_RAM | ucValue;
     }
     else if (btRS == LCD_DATA && btLF == OFF) {
       if (btCG_Set == OFF) // Daten werden in CG-RAM uebertragen
        if (btID) ucDD_Adr++; // Display im INCREMENT-Modus
        else ucDD_Adr--;
         *WRITE_DATA = ucValue; *WRITE_DATA = ucValue; }
       else if (btLF) { *WRITE_INS = SET_DD_RAM | ucValue;
         *WRITE_INS = SET_DD_RAM | ucValue; 
         ucDD_Adr = ucValue;
       }
       else { 
	     *WRITE_INS = ucValue; 
		 *WRITE_INS = ucValue;
	   }

//***************************************************************
// Die Ausgabe erfolgt ueber den LCD-Port
//***************************************************************
#elif LCD_DEV == LCD_PORT
     if (btLF == ON) {
       btRS = LCD_INST;
       ucDD_Adr = ucValue;
       ucValue = SET_DD_RAM | ucValue;
     }
     else if (btRS == LCD_DATA && btCG_Set == OFF) {
      if (btID) ucDD_Adr++; // Display im Increment-Modus
      else ucDD_Adr--;
     }
     sbR_W = LCD_WRITE;
 #if (LCD_NIBBLE == LOW_NIBBLE) 
     ucPort = (ucPort & 0xF0) | (ucValue >> 4);   // !! Nur gueltig wenn Datenport Px^0-Px^3
 #else
     ucPort = (ucPort & 0x0F) | (ucValue & 0xF0); // !! Nur gueltig wenn Datenport Px^4-Px^7
 #endif
     EN_CLK;
 #if (LCD_NIBBLE == LOW_NIBBLE) 
     ucPort = (ucPort & 0xF0) | (ucValue & 0x0F); // !! Nur gueltig wenn Datenport Px^0-Px^3 
 #else
     ucPort = (ucPort & 0x0F) | (ucValue << 4);    // !! Nur gueltig wenn Datenport Px^4-Px^7 
 #endif
     EN_CLK;

//***************************************************************
// Die Ausgabe erfolgt ueber den IC-Bus
//***************************************************************
#elif LCD_DEV == LCD_I2C
     if (btLF == ON) {
       btRS = LCD_INST;
       ucDD_Adr = ucValue;
       ucValue = SET_DD_RAM | ucValue;
     }
     else if (btRS == LCD_DATA && btCG_Set == OFF) {
      if (btID) ucDD_Adr++; // Display im Increment-Modus
      else ucDD_Adr--;
     }
     sbR_W = LCD_WRITE;
     sbEN = SET; 
     ucPort = (ucPort & 0xF0) | (ucValue >> 4); // !! Nur gueltig wenn Datenport Px^0-Px^3
     uc_I2C2IO( LCD_I2C_ADR, ucPort);
     sbEN = CLEAR; 
     uc_I2C2IO( LCD_I2C_ADR, ucPort);

     sbEN = SET; 
     ucPort = (ucPort & 0xF0) | (ucValue & 0x0F); // !! Nur gueltig wenn Datenport Px^0-Px^3:     en = HIGH; i2c2io( LCD_I2C_ADR, ucPort);
     uc_I2C2IO( LCD_I2C_ADR, ucPort);
     sbEN = CLEAR; 
     uc_I2C2IO( LCD_I2C_ADR, ucPort);

//***************************************************************
// Die Ausgabe erfolgt ueber den PIO
//***************************************************************
#elif LCD_DEV == LCD_PIO
     if (btLF == ON) {
       btRS = LCD_INST;
       ucDD_Adr = ucValue;
       ucValue = SET_DD_RAM | ucValue;
     }
     else if (btRS == LCD_DATA && btLF == OFF) {
       if (btCG_Set == OFF) // Daten werden in CG-RAM uebertragen
         if (btID) ucDD_Adr++; // Display im INCREMENT-Modus
         else ucDD_Adr--;
       stPIO.LCD_PIO_PORT.ucWrite = ucValue; 
       stPIO.ucControl = LCD_PIO_RS | SET_BIT_8255;
       stPIO.ucControl = LCD_PIO_EN | SET_BIT_8255;
       stPIO.ucControl = LCD_PIO_EN | CLR_BIT_8255;
       stPIO.ucControl = LCD_PIO_RS | CLR_BIT_8255;
     }
     if (btLF) { 
	   stPIO.LCD_PIO_PORT.ucWrite = SET_DD_RAM | ucValue;
       stPIO.ucControl = LCD_PIO_EN | SET_BIT_8255;
       stPIO.ucControl = LCD_PIO_EN | CLR_BIT_8255;
       ucDD_Adr = ucValue;
     }
     else { 
	   stPIO.LCD_PIO_PORT.ucWrite = ucValue; 
       stPIO.ucControl = LCD_PIO_EN | SET_BIT_8255;
       stPIO.ucControl = LCD_PIO_EN | CLR_BIT_8255;
	 }
#endif
     uc_Busy();               // BUSY-Abfrage 
     if (btLF == ON) { btLF = OFF; btRS = LCD_DATA; }
   }
   
  return(0);
}

//***************************************************************
// Funktionsname v_Wait() 
// Version: 1.0    Datum 
// Uebergabeparameter: uiTime
// Beschreibung: 
// Funktion wait() erzeugt Warteschleifen.                     
// In der Tabelle koennen Sie einige Durchlaufzeiten bei einem 
// SYSTEM_CLK von 12MHz ermitteln.                             
// Uebergabewert   Dauer                                       
//     1           30  sec                                    
//    10          150  sec                                    
//   100          1,3  msec                                    
//  1000           13  msec                                    
//***************************************************************
void v_Wait(uint uiTime) {                  
  uint uiStep;
  if (uiTime == 0) return;
  for (uiStep=0; uiStep < uiTime; uiStep++);
}
