//***************************************************************
// Modulname:    $Source: C:/c51_buecher/Teil2/software/LCD/LCD_Lib/rcs/Cg_ram.c $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.1 $
// Datum:        $Date: 2001/02/03 10:50:22Z $
// Qualitaet:    $State: Exp $
//***************************************************************
// Beschreibung:
// Laden der acht selbst definierbaren Zeichen in das CG-RAM.               
// In diesem Beispiel sind die zusaetzlichen Pfeile abgelegt. 
//***************************************************************
// Historie:
//==========
// $Log: Cg_ram.c $
// Revision 1.1  2001/02/03 10:50:22Z  MEBA
// Initial revision
//***************************************************************
// Steuerparameter:
//***************************************************************
#pragma
//***************************************************************
// globale Definitionen
//***************************************************************
#define CG_RAM_C

//***************************************************************
// verwendete Include Dateien
//***************************************************************

#include <defines.h>
#include <globals.h>
#include <stdio.h>
#include <lcd_def.h>
#include <cg_ram_lib.h>

bit btCG_Set;

//***************************************************************
// Funktionsname uc_Load_CGRam() 
// Version: 1.0    Datum 
// Uebergabeparameter: ucRAMAdr, pucAddress
// Beschreibung: 
// Die Funktion uc_LCDIni initialisiert den HD44780-Controller
//***************************************************************
uchar uc_Load_CGRam(uchar ucRAMAdr, uchar *pucAddress) {
  uchar ucRow,ucError;
  bit btIdo = btID;
  ucError = OK;
  btCG_Set = ON;
  btRS = LCD_INST;
  uc_SetInst(ENTRY | INCREMENT); // !! Wichtig fuer Grafikbibliothek
   putchar(SET_CG_RAM | ucRAMAdr << 3);  /* Startadresse im CG-RAM setzen */

  btRS = LCD_DATA;
     for (ucRow =0; ucRow <8; ucRow++) {  // Zeichen in das CG-RAM schreiben 
       putchar( *pucAddress);
       pucAddress++;
     }
  btRS = LCD_INST;
  if (!btIdo) uc_SetInst(ENTRY | DECREMENT);
   putchar(SET_DD_RAM | ucDD_Adr);  /* Startadresse im DD-RAM setzen */
  btRS = LCD_DATA;
  btCG_Set = OFF;
 return(ucError);
}
