// MD, dodefinoval som 4 riadkovy displej
//     dodal som  #define LCD_BUS  (_4BIT_BUS)		


//****************************************************************
// @doc
// @module LCD_DEF.h | Enthlt alle Definitionen fr die Ansteuerung
// des LCD HD44780 Controllers
// @end
//----------------------------------------------------------------
//***************************************************************
// Modulname:    $Source: C:/c51_buecher/Teil2/software/LCD/LCD_Port/rcs/lcd_def.h $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.2 $
// Datum:        $Date: 2001/03/10 11:20:53Z $
// Qualitt:     $State: Exp $
//***************************************************************
// Historie:
//==========
// $Log: lcd_def.h $
// Revision 1.2  2001/03/10 11:20:53Z  MEBA
// Die Definitionen wurden jetzt in die H-Files LCD_DEF.h und LCD_DEF_LIB.h
// aufgeteilt.
// Revision 1.1  2001/02/03 10:51:46Z  MEBA
// Initial revision
//***************************************************************
#ifndef LCD_DEF_H
  #define LCD_DEF_H


#include <lcd_def_lib.h>
//***************************************************************
// Definitionen
//***************************************************************
// Einstellung welche Anschlussart am LCD verwendet wurde

// MD
#define LCD_DEV    LCD_PORT  // @define LCD_DEV   | definiert die Ansteuerungsart
#define LCD_DATEN _4BIT_BUS  // @define LCD_DATEN | definiert die Datenbusbreite
#define LCD_COL          16  // @define LCD_COL   | definiert die Anzahl der sichtbaren Spalten 
#define LCD_ROWS          4  // @define LCD_ROWS  | definiert die Anzahl der sichtbaren Spalten 


#if (0) // MD
// Abfrage, ob eine Baugruppe mit vorhandener LCD-Ansterung verwendet wird	 
#ifdef LAB537	 
  #include <LAB537.h>
#endif
#endif

/* Definition der Anfangsadressen von mehrzeiligen Displays */

#if (LCD_ROWS >= 1 && LCD_ROWS <=4 && LCD_ROWS !=3 ) 
      #define _1_LINE      0x00
  #if (LCD_ROWS >=2)
      #define _2_LINE      0x40
    #if (LCD_ROWS == 4 && LCD_COL == 16)  // Verwaltung bei 4x16 Matrix
      #define _3_LINE      0x10
      #define _4_LINE      0x50
    #elif(LCD_ROWS == 4 && LCD_COL == 20) // Verwaltung bei 4x20 Matrix
      #define _3_LINE      0x14
      #define _4_LINE      0x54
    #endif
  #endif
#else
    #error Fehler_0101: in LCD_MAT_LIB.H                         
    #error Fehler: Es wurden keine/falsche Angaben in LCD_ROWS/LCD_COL angegeben
	#error Abhilfe: LCD_ROWS/LCD_COL mit korrektem Wert definieren
#endif
// Einstellung welche Anschlussbelegung des LCDs
// Ansteuerung ueber Datenbus

#if (LCD_DEV == LCD_ADR)	   
 #define LCD_BADR    (char*)0x28000 // !! Basisadresse eingeben !! 
 #define READ_DATA   (LCD_BADR) 
 #define WRITE_DATA  (LCD_BADR + 1) 
 #define READ_INS    (LCD_BADR + 2) 
 #define WRITE_INS   (LCD_BADR + 3)

 #define LCD_BUS  (_4BIT_BUS)		// MD

// Ansteuerung ueber Portpins
#elif (LCD_DEV == LCD_PORT)

#ifndef LCD_SFR 		 // Bei einigen Baugruppen ist die Belegung der LCD
 #define LCD_DATA_SFR P3 // vorgegeben. Die Definitionen werden dann vom H-File
 #define LCD_SFR P3      // vorgegeben. Die Definitionen werden dann vom H-File

#endif			         // uebernommen

#ifndef LCD_DEF_EN
 #define LCD_DEF_EN  1  // @define LCD_DEF_EN  | Definition der SFR-Adresse fr das EN-Signals 
 #define LCD_DEF_R_W 2  // @define LCD_DEF_R_W | Definition der SFR-Adresse fr das R/W-Signals 
 #define LCD_DEF_RS  0  // @define LCD_DEF_RS  | Definition von SFR-Adresse fr das RS-Signals 
 
 #define LCD_DEF_D4  4  // @define LCD_DEF_D3  | Definition der SFR-Adresse fr die Datenleitung D3
 #define LCD_DEF_D5  5  // @define LCD_DEF_D3  | Definition der SFR-Adresse fr die Datenleitung D3
 #define LCD_DEF_D6  6  // @define LCD_DEF_D3  | Definition der SFR-Adresse fr die Datenleitung D3
 #define LCD_DEF_D7  7  // @define LCD_DEF_D3  | Definition der SFR-Adresse fr die Datenleitung D3
#endif
// Hier erfolgt die alternative Ansteuerbeleung des LCD  (Pinwahl der Steuersignale)
 sbit  LCD_EN  = LCD_SFR ^ LCD_DEF_EN;  // @define LCD_EN  | Definition eines Bits in einer SFR-Adresse  
 sbit  LCD_R_W = LCD_SFR ^ LCD_DEF_R_W; // @define LCD_R_W | Definition eines Bits in einer SFR-Adresse 
 sbit  LCD_RS  = LCD_SFR ^ LCD_DEF_RS;  // @define LCD_RS  | Definition eines Bits in einer SFR-Adresse 

// Die Datenbits muessen in einem Nibble liegen und in aufsteigender Reihenfolge
// angeschlossen sein. Wird das untere Nibble verwendet, so ist die Definition
// LCD_NIBBLE auf 0 zu setzen. Beim oberen Nibble wird die Definition mit 1 definiert
#define LCD_NIBBLE HIGH_NIBBLE		   // Definition der Datenbits
#if (LCD_DATEN == _4BIT_BUS) 
 sbit  LCD_D4 = LCD_DATA_SFR ^ LCD_DEF_D4;  // @define LCD_D4  | Definition eines Bits in einer SFR-Adresse    
 sbit  LCD_D5 = LCD_DATA_SFR ^ LCD_DEF_D5;  // @define LCD_D5  | Definition eines Bits in einer SFR-Adresse 
 sbit  LCD_D6 = LCD_DATA_SFR ^ LCD_DEF_D6;  // @define LCD_D6  | Definition eines Bits in einer SFR-Adresse 
 sbit  LCD_D7 = LCD_DATA_SFR ^ LCD_DEF_D7;  // @define LCD_D7  | Definition eines Bits in einer SFR-Adresse 
#endif
#if (LCD_DATEN == _8BIT_BUS) 
 sbit  LCD_D0 = LCD_DATA_SFR ^ LCD_DEF_D0;  // @define LCD_D0  | Definition eines Bits in einer SFR-Adresse    
 sbit  LCD_D1 = LCD_DATA_SFR ^ LCD_DEF_D1;  // @define LCD_D1  | Definition eines Bits in einer SFR-Adresse 
 sbit  LCD_D2 = LCD_DATA_SFR ^ LCD_DEF_D2;  // @define LCD_D2  | Definition eines Bits in einer SFR-Adresse 
 sbit  LCD_D3 = LCD_DATA_SFR ^ LCD_DEF_D3;  // @define LCD_D3  | Definition eines Bits in einer SFR-Adresse 
 sbit  LCD_D4 = LCD_DATA_SFR ^ LCD_DEF_D4;
 sbit  LCD_D5 = LCD_DATA_SFR ^ LCD_DEF_D5;
 sbit  LCD_D6 = LCD_DATA_SFR ^ LCD_DEF_D6;
 sbit  LCD_D7 = LCD_DATA_SFR ^ LCD_DEF_D7;
 #endif

 #define EN_CLK LCD_DATA_SFR=ucPort; LCD_EN = 1; LCD_EN =0  // @define EN_CLK  | Definitiert eine Schreibsequenz zum HD44780-Controller 

// Ansteuerung ueber I2C-Bus
#elif (LCD_DEV == LCD_I2C)
 #define LCD_I2C_ADR PCF8574  // Definition des verwendeten Bausteins
#else
    #error Fehler_0100: in LCD_MAT_LIB.H                         
    #error Fehler: Es wurde kein Bus bzw. ungueltige Angabe zur Ansteuerung der LCD definiert
	#error Abhilfe: LCD_DEV mit korrektem Wert aus LCD_DEF.H definieren
#endif




//***************************************************************
// Deklarationen von Funktionen und Variablen
//***************************************************************
// Funktionsdeklarationen
extern uchar uc_LCDIni(uchar ucLCD_Control);
extern void  v_Wait(uint uiTime);
extern uchar uc_SetInst(uchar ucInst);
extern uchar uc_ReadData(void);
extern void  v_Busy(void);
extern uchar uc_Clrscr(void);
extern char  putchar (char c);

// Variablendeklaration bzw. Bitdefinitionen
extern bit btRS;
extern uchar ucDD_Adr; // Softwarezeiger fr Display DD-RAM
extern bit btID;        // Zeigt Modus INC/DEC vom HD44780 an

#endif
