//****************************************************************
// @doc
// @module phyCORE_581.h | Enthlt alle Definitionen fr die Baugruppe
// phyCORE-581 der Firma Phytec
// @end
//----------------------------------------------------------------
// Definitionen fuer MKS  !!
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Chip_inc/rcs/phyCORE_591.h $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.1 $
// Datum:        $Date: 2001/06/10 09:26:25Z $
// Qualitt:     $State: Exp $
// Historie:
//==========
// $Log: phyCORE_591.h $
// Revision 1.1  2001/06/10 09:26:25Z  MEBA
// Initial revision
//----------------------------------------------------------------

//***************************************************************
// Beschreibung: Allgemein
// Dieses H-File ist so aufgebaut, da alle bentigten Definitionen
// fr den jeweiligen Chip vorhanden sind. 
// Fr eine automatische Dokumentaion wird das Programm AUTODUCK
// eingesetzt.
// Das H-File kann beim C-Compiler als auch beim Assembler verwendet
// werden. (!! Versionen beachten !!)
// Beschreibung: Definitionen
//***************************************************************
//***************************************************************
#ifndef phyCORE_591_H
  #define phyCORE_591_H
//***************************************************************
// Definitionen ueber C-Compiler / Assembler
//***************************************************************
   #ifdef __C51__
     #if __C51__ < 602
      #error: !! ERROR, this files work only with the C-Compiler !!
      #error: !! Version 602 or higher !!
     #endif
   #endif
   #ifdef __A51__
     #if __A51__ < 601
      #error: !! ERROR, this files work only with the A51-Compiler !!
      #error: !! Version 602 or higher !!
     #endif
   #endif
#include <defines.h>
#include <REG591.H>

//***************************************************************
// Angaben ueber die verwendete Baugruppe und dessen Umfeld
//***************************************************************
// @type Definitionen | Definitionen fr die Baugruppe phyCORE 591
#define MIKROPRO            _83C591   // welcher Prozessor wird verwendet
#define SYSTEM_CLKHZ      12000000L   // Angabe in Hz
#define MACHINE_CYCLE             1   // Angabe in Sec 12 MHz Taktfrequenz
#define SYSTEM_CLK     SYSTEM_CLKHZ/1000000L  // Berechnung in MHz

// @define Definitionen von Adressen | Das IO-SW ist nach Reset auf 0x8000 !! Somit liegen
// die CS-Selekt-Adressen im Bereich 0xFD00 bis 0xFFFF. 
#define IO_SW       0x8000  // @define IO_SW           | IO-SW Offset-Adresse (phyCORE 591)
#define CS_USER1    0x7D00 | IO_SW // @define CS_USER1 | /CS-User     Adresse (phyCORE 591)
#define CS_USER2    0x7E00 | IO_SW // @define CS_USER1 | /CS-User     Adresse (phyCORE 591)
#define CS_USER3    0x7F00 | IO_SW // @define CS_USER1 | /CS-User     Adresse (phyCORE 591)


// @define Definitionen der CAN-Anbindung |  
// @define USE_CAN | Bei Definition wird ein struct fr CAN-Controller angelegt.  
// Diese Definition kann entfallen, da der C515C ueber einen internen CAN verfuegt.

// @define Definitionen der IC-Bus Anbindung |  
#define SDA_ADDRESS P1^7 // @define SDA_ADDRESS | Definition der der Portadresse fr SDA (phyCORE 591) 
#define SCL_ADDRESS P1^6 // @define SCL_ADDRESS | Definition der der Portadresse fr SCL (phyCORE 591) 

#endif
