//****************************************************************
// @doc
// @module RTC72421.h | Enthlt alle Definitionen fr den RTC
// RTC72421
// @end
//----------------------------------------------------------------
// Definitionen fuer MKS  !!
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Chip_inc/rcs/RTC72421.h $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.1 $
// Datum:        $Date: 2001/02/03 09:46:20Z $
// Qualitt:     $State: Exp $
// Historie:
//==========
// $Log: RTC72421.h $
// Revision 1.1  2001/02/03 09:46:20Z  MEBA
// Initial revision
//----------------------------------------------------------------

//***************************************************************
// Beschreibung: Allgemein
// Dieses H-File ist so aufgebaut, da alle bentigten Definitionen
// fr den jeweiligen Chip vorhanden sind. 
// Fr eine automatische Dokumentaion wird das Programm AUTODUCK
// eingesetzt.
// Das H-File kann beim C-Compiler als auch beim Assembler verwendet
// werden. (!! Versionen beachten !!)
// Beschreibung: Definitionen
// Auf die 72421-Register kann ber eine Struktur, teilweise mit 
// eingelagerten unions zugegriffen werden.
//***************************************************************
//***************************************************************
#ifndef RTC72421_H
  #define RTC72421_H
//***************************************************************
// Definitionen ueber C-Compiler / Assembler
//***************************************************************
   #ifdef __C51__
     #if __C51__ < 602
      #error: !! ERROR, this files work only with the C-Compiler !!
      #error: !! Version 602 or higher !!
     #endif
   #endif
   #ifdef __A51__
     #if __A51__ < 601
      #error: !! ERROR, this files work only with the A51-Compiler !!
      #error: !! Version 602 or higher !!
     #endif
   #endif
#include <defines.h>
//***************************************************************
// Definitionen zum Chip
// @struct RTC72421_DEC | 
//  Definitionen fr alle zulaessigen Register im RTC72421
//***************************************************************
struct RTC72421_DEC {
  union{
   uchar const ucRd;  // @field Lesen Sekunden 1
   uchar ucWr;        // @field Schreiben Sekunden 1
  }Sec01;
  union{
   uchar const ucRd;  // @field Lesen Sekunden 10
   uchar ucWr;        // @field Schreiben Sekunden 10
  }Sec10;
  union{
   uchar const ucRd;  // @field Lesen Minuten 1
   uchar ucWr;        // @field Schreiben Minuten 1
  }Min01;
  union{
   uchar const ucRd;  // @field Lesen Minuten 10
   uchar ucWr;        // @field Schreiben Minuten 10
  }Min10;
  union{
   uchar const ucRd;  // @field Lesen Stunden 1
   uchar ucWr;        // @field Schreiben Stunden 1
  }Std01;
  union{
   uchar const ucRd;  // @field Lesen Stunden 10
   uchar ucWr;        // @field Schreiben Stunden 10
  }Std10;
  union{
   uchar const ucRd;  // @field Lesen Tag 1
   uchar ucWr;        // @field Schreiben Tag 1
  }Tag01;
  union{
   uchar const ucRd;  // @field Lesen Tag 10
   uchar ucWr;        // @field Schreiben Tag 10
  }Tag10;
  union{
   uchar const ucRd;  // @field Lesen Monat 1
   uchar ucWr;        // @field Schreiben Monat 1
  }Mon01;
  union{
   uchar const ucRd;  // @field Lesen Monat 10
   uchar ucWr;        // @field Schreiben Monat 10
  }Mon10;
  union{
   uchar const ucRd;  // @field Lesen Jahr 1
   uchar ucWr;        // @field Schreiben Jahr 1
  }Jahr01;
  union{
   uchar const ucRd;  // @field Lesen Jahr 10
   uchar ucWr;        // @field Schreiben Jahr 10
  }Jahr10;
  union{
   uchar const ucRd;  // @field Lesen Wochentage
   uchar ucWr;        // @field Schreiben Wochentage
  }Woche;
  union{
   uchar const ucRd;  // @field Lesen Control D Register
   uchar ucWr;        // @field Schreiben Control D Register
  }ControlD;
  union{
   uchar const ucRd;  // @field Lesen Control E Register
   uchar ucWr;        // @field Schreiben Control E Register
  }ControlE;
  union{
   uchar const ucRd;  // @field Lesen Control F Register
   uchar ucWr;        // @field Schreiben Control F Register
  }ControlF;
};

// @globalv Zwischenspeicher fuer RTC
extern uchar xdata aucRTCTime[7];  

// @globalv Definition fuer RTC
extern bit btTimeSet;

extern uchar uc_RTC72421_Time(uchar ucRegister, bit btRW);
extern uchar uc_RTC72421_Pulse(uchar ucControlE);


// @type Definitionen | Definitionen fr den RTC72421
// @define Allgemeine Definitionen |  
#define RTC_DEF   1    // @define RTC_DEF   | 
#define RTC_UNDEF 0	   // @define RTC_UNDEF | 
#define RTC_READ  0	   // @define RTC_READ  |
#define RTC_WRITE 1	   // @define RTC_WRITE |

// @define Definitionen fr Rueckgaben |Ungueltige Daten 
#define ERR_SEC  0x01  // @define ERR_SEC   | 
#define ERR_MIN  0x02  // @define ERR_MIN   |
#define ERR_HOUR 0x03  // @define ERR_HOUR  |
#define ERR_DAY  0x04  // @define ERR_DAY   |
#define ERR_MON  0x05  // @define ERR_MON   |
#define ERR_YEAR 0x06  // @define ERR_YEAR  |
#define ERR_WEEK 0x07  // @define ERR_WEEK  |

// @define Definitionen fr der Bits im Control Register F
#define RTC_STOP  B0010  // @define RTC_STOP  |   
#define RTC_RESET B0001  // @define RTC_RESET |
#define RTC_24H   B0100  // @define RTC_24H   |
#define RTC_12H   B0000  // @define RTC_12H   |

// @define Definitionen fr der Bits im Control Register D
#define RTC_HOLD  B0001  // @define RTC_HOLD  |
#define RTC_BUSY  B0010  // @define RTC_BUSY  |
#define RTC_ADJ   B1000  // @define RTC_ADJ   | 30 sec-Register zurcksetzen
#define RTC_IRQ_F B0100  // @define RTC_IRQ_F | IRQ-Flag

#define RTC_PM_AM B0100  // @define RTC_PM_AM | PM/AM in 10-hour Register 

// @define Definitionen fr der Bits im Control Register E
#define PER_15MSEC      B0000     // @define PER_15MSEC | t0 + t1 in Control Register E
#define PER_1_SEC       B0100	  // @define PER_1_SEC  |
#define PER_1_MIN       B1000	  // @define PER_1_MIN  |
#define PER_1_HOUR      B1100	  // @define PER_1_HOUR |
#define RTC_ITRPT       B0010	  // @define RTC_ITRPT  |
#define RTC_STND        B0000	  // @define RTC_STND   |
#define RTC_PULSE_START B0000	  // @define RTC_PULSE_START |
#define RTC_PULSE_STOP  B0001	  // @define RTC_PULSE_STOP  |
#define RTC_REG_READ    B11110000 // @define RTC_REG_READ    |

// @define Definitionen fr aucRTC-Handling 
#define SEC  0	    // @define SEC  |
#define MIN  1	    // @define MIN  |
#define HOUR 2	    // @define HOUR |
#define DAY  3	    // @define DAY  |
#define MON  4	    // @define MON  |
#define YEAR 5	    // @define YEAR |
#define WEEK 6	    // @define WEEK |

// @define Zustzliche Definitionen | bergabeparameter in ucReg */
#define TIME         7  // @define TIME        | gesamte Uhrzeit
#define DATE         8  // @define DATE        | gesamtes Datum
#define ALL_TIME_12  9  // @define ALL_TIME_12 | 12 Stunden-Modus mit PM/AM Bit
#define ALL_TIME_24 10  // @define ALL_TIME_24 | 24 Stunden-Modus


#endif
