//****************************************************************
// @doc
// @module PIO_8255.h | Enthlt alle Definitionen fr den 
// Controller PIO 8255/71055
// @end
//----------------------------------------------------------------
// Definitionen fuer MKS  !!
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Chip_inc/rcs/PIO_8255.h $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.1 $
// Datum:        $Date: 2001/02/03 09:46:21Z $
// Qualitt:     $State: Exp $
// Historie:
//==========
// $Log: PIO_8255.h $
// Revision 1.1  2001/02/03 09:46:21Z  MEBA
// Initial revision
//----------------------------------------------------------------

//***************************************************************
// Beschreibung: Allgemein
// Dieses H-File ist so aufgebaut, da alle bentigten Definitionen
// fr den jeweiligen Chip vorhanden sind. 
// Fr eine automatische Dokumentaion wird das Programm AUTODUCK
// eingesetzt.
// Das H-File kann beim C-Compiler als auch beim Assembler verwendet
// werden. (!! Versionen beachten !!)
// Beschreibung: Definitionen
// Auf die PIO 8255-Register kann ber eine Struktur, teilweise mit 
// eingelagerten unions zugegriffen werden.
//***************************************************************
//***************************************************************
#ifndef PIO_8255_H
  #define PIO_8255_H

//***************************************************************
// Definitionen zum Chip
// @struct PIO8255_DEC | 
//  Definitionen fr alle zulaessigen Register im 8255
//***************************************************************
struct PIO8255_DEC {
  union{
   uchar const ucRead;  // @field Addressbyte 0 Channel A Read
   uchar ucWrite;	    // @field Addressbyte 0 Channel A Write
  }Ch_A;

  union{
   uchar const ucRead;  // @field Addressbyte 1 Channel B Read
   uchar ucWrite;       // @field Addressbyte 1 Channel B Write
  }Ch_B;

  union{
   uchar const ucRead;  // @field Addressbyte 2 Channel C Read.
   uchar ucWrite;       // @field Addressbyte 2 Channel C Write
  }Ch_C;

  uchar ucControl;		// @field Addressbyte 3 
};

//***************************************************************
// Beispiel fr eine Definition
// struct PIO8255_DEC xdata stPIO _at_ 0xF600; 
// @type Definitionen | Definitionen fr den 8255/71055
// @define Definitionen der Bits im Steuerregister | Betriebsartauswahl 
//***************************************************************
  #define PORT_A_OUT    B10000000  // @define PORT_A_OUT | Port A Ausgabe       
  #define PORT_A_IN     B10010000  // @define PORT_A_IN  | Port A Eingabe

  #define PORT_B_OUT    B10000000  // @define PORT_B_OUT | Port B Ausgabe       
  #define PORT_B_IN     B10000010  // @define PORT_B_IN  | Port B Eingabe
  
  #define PORT_CL_OUT   B10000000  // @define PORT_CL_OUT | Port C Bit 0-3 Ausgabe       
  #define PORT_CL_IN    B10000001  // @define PORT_CL_IN  | Port C Bit 0-3 Eingabe

  #define PORT_CH_OUT   B10000000  // @define PORT_CH_OUT | Port C Bit 4-7 Ausgabe       
  #define PORT_CH_IN    B10000001  // @define PORT_CH_IN  | Port C Bit 4-7 Eingabe

  #define PORT_B_BETR_0 B10000000  // @define PORT_B_BETR_0 | Gruppe B Betriebsart 0
  #define PORT_B_BETR_1 B10000100  // @define PORT_B_BETR_1 | Gruppe B Betriebsart 1

  #define PORT_A_BETR_0 B10000000  // @define PORT_A_BETR_0 | Gruppe A Betriebsart 0
  #define PORT_A_BETR_1 B10100000  // @define PORT_A_BETR_1 | Gruppe A Betriebsart 1
  #define PORT_A_BETR_2 B11000000  // @define PORT_A_BETR_2 | Gruppe A Betriebsart 2

// @define Definitionen fuer Einzelbitsetzen (Port C) im Steuerregister
  #define SET_BIT_8255  B00000001  // @define SET_BIT_8255 | Setzen eines Portbits       
  #define CLR_BIT_8255  B00000000  // @define CLR_BIT_8255 | Loeschen eines Portbits       

  #define PORT_C_PIN0   B00000000  // @define PORT_C_PIN0 | Pin 0 von Port C
  #define PORT_C_PIN1   B00000010  // @define PORT_C_PIN1 | Pin 1 von Port C
  #define PORT_C_PIN2   B00000100  // @define PORT_C_PIN2 | Pin 2 von Port C
  #define PORT_C_PIN3   B00000110  // @define PORT_C_PIN3 | Pin 3 von Port C
  #define PORT_C_PIN4   B00001000  // @define PORT_C_PIN4 | Pin 4 von Port C
  #define PORT_C_PIN5   B00001010  // @define PORT_C_PIN5 | Pin 5 von Port C
  #define PORT_C_PIN6   B00001100  // @define PORT_C_PIN6 | Pin 6 von Port C
  #define PORT_C_PIN7   B00001110  // @define PORT_C_PIN7 | Pin 7 von Port C

#endif
