//****************************************************************
// @doc
// @module PCF8584.h | Enthlt alle Definitionen fr den IC-Bus
// Controller PCF8584
// @end
//----------------------------------------------------------------
// Definitionen fuer MKS  !!
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Chip_inc/rcs/PCF8584.H $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.1 $
// Datum:        $Date: 2001/02/03 09:46:21Z $
// Qualitt:     $State: Exp $
// Historie:
//==========
// $Log: PCF8584.H $
// Revision 1.1  2001/02/03 09:46:21Z  MEBA
// Initial revision
//----------------------------------------------------------------

//***************************************************************
// Beschreibung: Allgemein
// Dieses H-File ist so aufgebaut, da alle bentigten Definitionen
// fr den jeweiligen Chip vorhanden sind. 
// Fr eine automatische Dokumentaion wird das Programm AUTODUCK
// eingesetzt.
// Das H-File kann beim C-Compiler als auch beim Assembler verwendet
// werden. (!! Versionen beachten !!)
// Beschreibung: Definitionen
// Auf die PCF8584-Register kann ber eine Struktur, teilweise mit 
// eingelagerten unions zugegriffen werden.
//***************************************************************
//***************************************************************
#ifndef PCF8584_H
  #define PCF8584_H
//***************************************************************
// Definitionen ueber C-Compiler / Assembler
//***************************************************************
   #ifdef __C51__
     #if __C51__ < 602
      #error: !! ERROR, this files work only with the C-Compiler !!
      #error: !! Version 602 or higher !!
     #endif
   #endif
   #ifdef __A51__
     #if __A51__ < 601
      #error: !! ERROR, this files work only with the A51-Compiler !!
      #error: !! Version 602 or higher !!
     #endif
   #endif
#include <defines.h>
//***************************************************************
// Definitionen zum Chip
// @struct PCF8584_DEC | 
//  Definitionen fr alle zulaessigen Register im PCF8584
//***************************************************************
struct PCF8584_DEC {
  union{
    uchar volatile ucWrSlvAddress;     // @field Register S0'
    uchar volatile const ucRdI2CValue; // @field Register S0 data  buffer
    uchar volatile ucWrI2CValue; 	   // @field Register S0 shift register
    uchar volatile ucClockRegister;    // @field Register S2 clock register 
    uchar volatile ucIntVector;        // @field Register S3 interrupt vector 
  }S0;

  union{
    uchar volatile const ucStatus;     // @field Register S1 Status  register
    uchar volatile ucControl;          // @field Register S1 Control register
  }S1;

}; 

// @type Definitionen | Definitionen fr den PCF8584
// @define Definitionen der Bits im Steuerregister A0 = 0 im PCF8584 |  
#define S0_DATA     B01000000 // @define S0_DATA  | Datenregister 
#define S0_SLAVE    B00000000 // @define S0_SLAVE | Slave Addresse des PCF8584
#define S3_INT_VEC  B00010000 // @define S3_INT_VEC | Einschreiben des Interrupt Vektors
#define S2_CLK      B00100000 // @define S2_CLK | Definition des Clock Registers

// @define Definitionen  der Bits im Steuerregister S1 Register (schreibend) im PCF8584
#define PIN    B10000000 // @define PIN | pending interrupt not      
#define ESO    B01000000 // @define ESO | enable serial output
#define S0_REG B00000000 // @define S0_REG | S0/S0' register
#define S2_REG B00100000 // @define S2_REG | S2 clock register
#define S3_REG B00010000 // @define S3_REG | S3 interrupt register

#define ENI    B00001000 // @define ENI  | enable external interrupt output 
#define STA    B00000100 // @define STA  | start
#define STO    B00000010 // @define STO  | stop
#define _ACK   B00000001 // @define _ACK | acknowledge

// @define Definitionen  der Bits im Steuerregister S1 Register (lesend) im PCF8584
#define PIN    B10000000 // @define PIN | pending interrupt not     
#define xxx    B01000000 // @define xxx | nicht definiert
#define STS    B00100000 // @define STS | slave stop detected
#define BER    B00010000 // @define BER | bus error
#define AD0    B00001000 // @define AD0 | own address detected
#define LRB    B00001000 // @define LRB | own address detected
#define AAS    B00000100 // @define AAS | addesses as slave
#define LAB    B00000010 // @define LAB | lost arbitration bit
#define _BB    B00000001 // @define _BB | bus busy

// @define Definitionen  der Bits im Steuerregister S2 Register (schreibend) im PCF8584
#define FSCL90 B00000000 // @define FSCL90 | fSCL 90 kHz
#define FSCL45 B00000001 // @define FSCL45 | fSCL 45 kHz
#define FSCL11 B00000010 // @define FSCL11 | fSCL 11 kHz
#define FSCL01 B00000011 // @define FSCL01 | fSCL  1.5 kHz
#define FCLK03 B00000000 // @define FCLK03 | fCLK  3 MHz
#define FCLK04 B00010000 // @define FCLK04 | fCLK  4.43 MHz
#define FCLK06 B00010100 // @define FCLK06 | fCLK  6 MHz
#define FCLK08 B00011000 // @define FCLK08 | fCLK  8 MHz
#define FCLK12 B00011100 // @define FCLK12 | fCLK 12 MHz

#endif

