//****************************************************************
// @doc
// @module MOD515.h | Enthlt alle Definitionen fr die Baugruppe
// MOD515 der Firma LIPOWSKY
// @end
//----------------------------------------------------------------
// Definitionen fuer MKS  !!
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Chip_inc/rcs/MOD515.h $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.2 $
// Datum:        $Date: 2001/06/10 10:03:50Z $
// Qualitt:     $State: Exp $
// Historie:
//==========
// $Log: MOD515.h $
// Revision 1.2  2001/06/10 10:03:50Z  MEBA
// Aenderung des MACHINE_CYCLE in 2. Dieser Wert enthaelt
// das Teilerverhaeltnis zu 12 Taktzyklen
// Revision 1.1  2001/06/10 09:26:15Z  MEBA
// Initial revision
//----------------------------------------------------------------

//***************************************************************
// Beschreibung: Allgemein
// Dieses H-File ist so aufgebaut, da alle bentigten Definitionen
// fr den jeweiligen Chip vorhanden sind. 
// Fr eine automatische Dokumentaion wird das Programm AUTODUCK
// eingesetzt.
// Das H-File kann beim C-Compiler als auch beim Assembler verwendet
// werden. (!! Versionen beachten !!)
// Beschreibung: Definitionen
//***************************************************************
//***************************************************************
#ifndef MOD515_H
  #define MOD515_H
//***************************************************************
// Definitionen ueber C-Compiler / Assembler
//***************************************************************
   #ifdef __C51__
     #if __C51__ < 602
      #error: !! ERROR, this files work only with the C-Compiler !!
      #error: !! Version 602 or higher !!
     #endif
   #endif
   #ifdef __A51__
     #if __A51__ < 601
      #error: !! ERROR, this files work only with the A51-Compiler !!
      #error: !! Version 602 or higher !!
     #endif
   #endif
#include <defines.h>
#include <REG515C.H>

//***************************************************************
// Angaben ueber die verwendete Baugruppe und dessen Umfeld
//***************************************************************
// @type Definitionen | Definitionen fr die Baugruppe MOD515
#define MIKROPRO             _C515C   // welcher Prozessor wird verwendet
#define SYSTEM_CLKHZ      10000000L   // Angabe in Hz
#define MACHINE_CYCLE             2   // Angabe des Teilerverhaeltnis zu 12 MHz
#define SYSTEM_CLK     SYSTEM_CLKHZ/1000000L  // Berechnung in MHz

// @define Definitionen von Adressen |  

#define CS_USER1       0xE800  // @define CS_USER1      | /CS-User        Adresse (MOD515)
#define CS_USER2       0xEC00  // @define CS_USER2      | /CS-User        Adresse (MOD515)
#define CS_LCD         0xF000  // @define CS_LCD        | /CS-LCD         Adresse (MOD515)
#define CS_BANKSWITCH  0xF000  // @define CS_BANKSWITCH | /CS_BANKSWITCH  Adresse (MOD515)


// @define Definitionen der LCD-Port-Anbindung (SFR-Anschlussbelegung) |  
#define LCD_SFR P5	   // @define LCD_SFR | Angabe der Portadresse (MOD515) 
#define LCD_DEF_EN  3  // @define LCD_DEF_EN  | Definition der SFR-Adresse fr das EN-Signals 
#define LCD_DEF_R_W    // @define LCD_DEF_R_W | Definition der SFR-Adresse fr das R/W-Signals 
#define LCD_DEF_RS  1  // @define LCD_DEF_RS  | Definition von SFR-Adresse fr das RS-Signals 

#define LCD_DEF_D0  4  // @define LCD_DEF_D0  | Definition der SFR-Adresse fr die Datenleitung D0
#define LCD_DEF_D1  5  // @define LCD_DEF_D1  | Definition der SFR-Adresse fr die Datenleitung D1
#define LCD_DEF_D2  6  // @define LCD_DEF_D2  | Definition der SFR-Adresse fr die Datenleitung D2
#define LCD_DEF_D3  7  // @define LCD_DEF_D3  | Definition der SFR-Adresse fr die Datenleitung D3


// @define Definitionen der CAN-Anbindung |  
// @define USE_CAN | Bei Definition wird ein struct fr CAN-Controller angelegt.  
// Diese Definition kann entfallen, da der C515C ueber einen internen CAN verfuegt.

// @define Definitionen der IC-Bus Anbindung |  
#define SDA_ADDRESS P4^4 // @define SDA_ADDRESS | Definition der der Portadresse fr SDA (MOD515) 
#define SCL_ADDRESS P1^6 // @define SCL_ADDRESS | Definition der der Portadresse fr SCL (MOD515) 

#endif
