//****************************************************************
// @doc
// @module MCB517AC.h | Enthlt alle Definitionen fr die Baugruppe
// MCB517AC der Firma Keil
// @end
//----------------------------------------------------------------
// Definitionen fuer MKS  !!
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Chip_inc/rcs/MCB517AC.h $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.2 $
// Datum:        $Date: 2001/06/10 09:22:12Z $
// Qualitt:     $State: Exp $
// Historie:
//==========
// $Log: MCB517AC.h $
// Revision 1.2  2001/06/10 09:22:12Z  MEBA
// Angabe des Systemclocks und des Mikrocontroller mit augenommen.
// Revision 1.1  2001/02/03 09:46:21Z  MEBA
// Initial revision
//----------------------------------------------------------------

//***************************************************************
// Beschreibung: Allgemein
// Dieses H-File ist so aufgebaut, da alle bentigten Definitionen
// fr den jeweiligen Chip vorhanden sind. 
// Fr eine automatische Dokumentaion wird das Programm AUTODUCK
// eingesetzt.
// Das H-File kann beim C-Compiler als auch beim Assembler verwendet
// werden. (!! Versionen beachten !!)
// Beschreibung: Definitionen
//***************************************************************
//***************************************************************
#ifndef MCB517AC_H
  #define MCB517AC_H
//***************************************************************
// Definitionen ueber C-Compiler / Assembler
//***************************************************************
   #ifdef __C51__
     #if __C51__ < 602
      #error: !! ERROR, this files work only with the C-Compiler !!
      #error: !! Version 602 or higher !!
     #endif
   #endif
   #ifdef __A51__
     #if __A51__ < 601
      #error: !! ERROR, this files work only with the A51-Compiler !!
      #error: !! Version 602 or higher !!
     #endif
   #endif
#include <defines.h>
#include <81C90.h>
#include <REG517A.H>

//***************************************************************
// Angaben ueber die verwendete Baugruppe und dessen Umfeld
//***************************************************************
// @type Definitionen | Definitionen fr die Baugruppe MCB517AC
#define MIKROPRO             _80517   // welcher Prozessor wird verwendet
#define SYSTEM_CLKHZ      12000000L   // Angabe in Hz
#define MACHINE_CYCLE             1   // Angabe in Sec 12 MHz Taktfrequenz
#define SYSTEM_CLK     SYSTEM_CLKHZ/1000000L  // Berechnung in MHz

// @define Definitionen von Adressen |  

#define CS_USER 0xF600	   // @define CS_USER  | /CS-User Adresse (MCB517AC)
#define LED_PORT P4		   // @define LED_PORT | Angabe der Portadresse (MCB517AC) 
sbit sbLED0 = LED_PORT^0;  // @define LED0 | Definition von LED 0
sbit sbLED1 = LED_PORT^1;  // @define LED1 | Definition von LED 1
sbit sbLED2 = LED_PORT^2;  // @define LED2 | Definition von LED 2
sbit sbLED3 = LED_PORT^3;  // @define LED3 | Definition von LED 3
sbit sbLED4 = LED_PORT^4;  // @define LED4 | Definition von LED 4
sbit sbLED5 = LED_PORT^5;  // @define LED5 | Definition von LED 5
sbit sbLED6 = LED_PORT^6;  // @define LED6 | Definition von LED 6
sbit sbLED7 = LED_PORT^7;  // @define LED7 | Definition von LED 7

// @define Definitionen der CAN-Anbindung |  
// @define USE_CAN | Bei Definition wird ein struct fr CAN-Controller angelegt.  
#ifdef USE_CAN
  struct SAE91C90_DEC xdata SAE91C90 _at_ 0xF700; 
#endif

#endif
