//****************************************************************
// @doc
// @module LAB537.h | Enthlt alle Definitionen fr die Baugruppe
// LAB537 der Firma Rakers
// @end
//----------------------------------------------------------------
// Definitionen fuer MKS  !!
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Chip_inc/rcs/LAB537.h $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.3 $
// Datum:        $Date: 2001/06/10 09:20:37Z $
// Qualitt:     $State: Exp $
// Historie:
//==========
// $Log: LAB537.h $
// Revision 1.3  2001/06/10 09:20:37Z  MEBA
// Angabe des Systemtaktes und des Mikrocontroller mit aufgenommen.
// Revision 1.2  2001/06/10 09:08:05Z  MEBA
// Anschlubelegung fuer die LCD mit aufgenommen
// H-File 81C90.h mit eingefuegt
// Revision 1.1  2001/02/04 11:51:33Z  MEBA
// Initial revision
//----------------------------------------------------------------

//***************************************************************
// Beschreibung: Allgemein
// Dieses H-File ist so aufgebaut, da alle bentigten Definitionen
// fr den jeweiligen Chip vorhanden sind. 
// Fr eine automatische Dokumentaion wird das Programm AUTODUCK
// eingesetzt.
// Das H-File kann beim C-Compiler als auch beim Assembler verwendet
// werden. (!! Versionen beachten !!)
// Beschreibung: Definitionen
//***************************************************************
//***************************************************************
#ifndef LAB537_H
  #define LAB537_H
//***************************************************************
// Definitionen ueber C-Compiler / Assembler
//***************************************************************
   #ifdef __C51__
     #if __C51__ < 602
      #error: !! ERROR, this files work only with the C-Compiler !!
      #error: !! Version 602 or higher !!
     #endif
   #endif
   #ifdef __A51__
     #if __A51__ < 601
      #error: !! ERROR, this files work only with the A51-Compiler !!
      #error: !! Version 602 or higher !!
     #endif
   #endif
#include <defines.h>
#include <81C90.h>
//#include <REG517A.H>

//***************************************************************
// Angaben ueber die verwendete Baugruppe und dessen Umfeld
//***************************************************************
// @type Definitionen | Definitionen fr die Baugruppe MCB517AC
#define MIKROPRO             _80517   // welcher Prozessor wird verwendet
#define SYSTEM_CLKHZ      12000000L   // Angabe in Hz
#define MACHINE_CYCLE             1   // Angabe in Sec 12 MHz Taktfrequenz
#define SYSTEM_CLK     SYSTEM_CLKHZ/1000000L  // Berechnung in MHz

//***************************************************************
// Angaben ueber die verwendete Baugruppe und dessen Umfeld
//***************************************************************
// @type Definitionen | Definitionen fr die Baugruppe LAB537
// @define Definitionen von Adressen |  

#define CS_USER1       0xFF90  // @define CS_USER1      | /CS-User    Adresse (LAB537)
#define CS_USER2       0xFF98  // @define CS_USER2      | /CS-User    Adresse (LAB537)
#define CS_PCF8584     0xFFA0  // @define CS_PCF8584    | /CS-PCF8584 Adresse (LAB537)
#define CS_LCD         0xFF80  // @define CS_LCD        | /CS-LCD     Adresse (LAB537)
#define CS_BANKSWITCH  0xFF80  // @define CS_BANKSWITCH | /CS_BANKSWITCH  Adresse (LAB537)

#define LED_PORT P4		   // @define LED_PORT | Angabe der Portadresse (LAB537) 
sbit sbLED0 = LED_PORT^0;  // @define LED0 | Definition von LED 0
sbit sbLED1 = LED_PORT^1;  // @define LED1 | Definition von LED 1
sbit sbLED2 = LED_PORT^2;  // @define LED2 | Definition von LED 2
sbit sbLED3 = LED_PORT^3;  // @define LED3 | Definition von LED 3
sbit sbLED4 = LED_PORT^4;  // @define LED4 | Definition von LED 4
sbit sbLED5 = LED_PORT^5;  // @define LED5 | Definition von LED 5
sbit sbLED6 = LED_PORT^6;  // @define LED6 | Definition von LED 6
sbit sbLED7 = LED_PORT^7;  // @define LED7 | Definition von LED 7

#define LED_PORT1 P1	    // @define LED_PORT1 | Angabe der Portadresse (LAB537) 
sbit sbLED8  = LED_PORT1^0; // @define LED0 | Definition von LED 0
sbit sbLED9  = LED_PORT1^1; // @define LED1 | Definition von LED 1
sbit sbLED10 = LED_PORT1^2; // @define LED2 | Definition von LED 2
sbit sbLED11 = LED_PORT1^3; // @define LED3 | Definition von LED 3
sbit sbLED12 = LED_PORT1^4; // @define LED4 | Definition von LED 4
sbit sbLED13 = LED_PORT1^5; // @define LED5 | Definition von LED 5
sbit sbLED14 = LED_PORT1^6; // @define LED6 | Definition von LED 6
sbit sbLED15 = LED_PORT1^7; // @define LED7 | Definition von LED 7

// @define Definitionen der LCD-Port-Anbindung (SFR-Anschlussbelegung) |  
#define LCD_SFR P5	   // @define LCD_SFR | Angabe der Portadresse (LAB537) 
#define LCD_DATA_SFR P5	   // @define LCD_SFR | Angabe der Portadresse (LAB537) 
#define LCD_DEF_EN  3  // @define LCD_DEF_EN  | Definition der SFR-Adresse fr das EN-Signals 
#define LCD_DEF_R_W 2  // @define LCD_DEF_R_W | Definition der SFR-Adresse fr das R/W-Signals 
#define LCD_DEF_RS  1  // @define LCD_DEF_RS  | Definition von SFR-Adresse fr das RS-Signals 

#define LCD_DEF_D4  4  // @define LCD_DEF_D0  | Definition der SFR-Adresse fr die Datenleitung D0
#define LCD_DEF_D5  5  // @define LCD_DEF_D1  | Definition der SFR-Adresse fr die Datenleitung D1
#define LCD_DEF_D6  6  // @define LCD_DEF_D2  | Definition der SFR-Adresse fr die Datenleitung D2
#define LCD_DEF_D7  7  // @define LCD_DEF_D3  | Definition der SFR-Adresse fr die Datenleitung D3


// @define Definitionen der CAN-Anbindung |  
// @define USE_CAN | Bei Definition wird ein struct fr CAN-Controller angelegt.  
#ifdef USE_CAN
  #define CAN_ADDRESS  0xFF00 // nur bei gestecktem CAN-Gal gueltig  
#endif


#endif
