//****************************************************************
// @doc
// @module I2C_Chip_Lib.h | Enthlt Definitionen von Chipadressen fr 
// den I2C-Bus
// @end
//----------------------------------------------------------------
// Definitionen fuer MKS  !!
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Chip_inc/rcs/I2c_Chip_Lib.h $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.3 $
// Datum:        $Date: 2001/06/16 09:51:29Z $
// Qualitt:     $State: Exp $
// Historie:
//==========
// $Log: I2c_Chip_Lib.h $
// Revision 1.3  2001/06/16 09:51:29Z  MEBA
// Definitionen fuer LM75/DS75 Temperatursensor hinzugefuegt
// Revision 1.2  2001/06/10 09:05:48Z  MEBA
// Bausteine SAA104 und LM75 hinzugefuegt
// Revision 1.1  2001/02/03 09:46:20Z  MEBA
// Initial revision
//----------------------------------------------------------------

//***************************************************************
// Beschreibung: Allgemein
// Dieses H-File ist so aufgebaut, da alle bentigten Definitionen
// fr den jeweiligen Chip vorhanden sind. 
// Fr eine automatische Dokumentaion wird das Programm AUTODUCK
// eingesetzt.
// Das H-File kann beim C-Compiler als auch beim Assembler verwendet
// werden. (!! Versionen beachten !!)
// Beschreibung: Definitionen
// In dieser Bibliothek sind die Device-Codes fuer einige 
// I2C-Busbausteine hinterlegt. Die CE-bits !muessen! noch mit
// den Definitionen verodert werden.   
// In der Tablelle koennen Sie ersehen, das es auch Adressueber-
// schneidungen bei den einzelnen Bausteinen gibt. 
// x = cs_    A = Bit fuer Adressauswahl   w = R/W_ Bit
// Ergaenzungen durch RH 
// Datum 27.07.2000
// Die Bibliothek wurde um Bausteine der Firmen Chrontel, Crystal
// und ST erweitert.
//***************************************************************
//***************************************************************
#ifndef I2C_CHIP_LIB_H
  #define I2C_CHIP_LIB_H
                            
// @type Definitionen | Definitionen fr den IC-Bus
                            
// @define Definitionen fr die ST-Bibliothek |
//                                              Bituebersicht
#define ST24C01  B10100000 // @define ST24C01 | 128 * 8 Byte EEPROM              1010xxxw
#define ST24C02  B10100000 // @define ST24C02 | 256 * 8 Byte EEPROM              1010xxxw
#define ST24C04  B10100000 // @define ST24C04 | 512 * 8 Byte EEPROM              1010xxAw
#define ST24C08  B10100000 // @define ST24C08 | 1024* 8 Byte EEPROM              1010xAAw
#define ST24C16  B10100000 // @define ST24C16 | 2048* 8 Byte EEPROM              1010AAAw
#define ST24164  B10000000 // @define ST24164 | 2048* 8 Byte EEPROM              1xxxAAAw
#define STA013   B10000110 // @define STA013  | MPEG 2.5 Layer III Audio-Decoder 1000011w

// @define Definitionen fr die PHILIPS-Bibliothek |
//                           Bituebersicht
#define PCF8570  B10100000 // @define PCF8570 | 128 * 8 Byte RAM     1010AAAw
#define PCF8570C B10110000 // @define PCF8570C| 128 * 8 Byte RAM     1010AAAw
#define PCF8571  B10100000 // @define PCF8571 | 256 * 8 Byte RAM     1010xxxw
#define PCF8583  B10100000 // @define PCF8583 | RTC+256 * 8 Byte RAM 1010xxxw
#define PCF8574  B01000000 // @define PCF8574 | 8 bit I/O-Expander   1000xxxw
#define PCF8581  B10100000 // @define PCF8581 | 128 * 8 Byte EEPROM  1010AAAw
#define A0           B0010 // @define A0 |  Adressselektor
#define A1           B0100 // @define A1 |  Adressselektor
#define A2           B1000 // @define A2 |  Adressselektor
#define SAA1064  B01110000 // @define SAA1064 | 4-digit LED-Driver   01110AAw
#define SAA_CTR  B00000000 // @define SAA_CTR | Adresse des Control-Registers
#define SAA_DG1  B00000001 // @define SAA_DG1 | Adresse des Digit 1-Registers
#define SAA_DG2  B00000010 // @define SAA_DG2 | Adresse des Digit 2-Registers
#define SAA_DG3  B00000011 // @define SAA_DG3 | Adresse des Digit 3-Registers
#define SAA_DG4  B00000100 // @define SAA_DG4 | Adresse des Digit 4-Registers


// @define Definitionen fr die Crystal-Bibliothek |
#define CS4221  B00100000  // @define CS4221 | 24-Bit Stereo-Audio-Codec 001000xw
#define CS4228  B00100000  // @define CS4228 | 24-Bit Surround-Sound-Codec 001000xw
#define CS8405A B00100000  // @define CS8405A| 96kHz Digital Audio Interface Transmitter 0010xxxw
#define CS8415A B00100000  // @define CS8415A| 96kHz Digital Audio Interface Resciever 0010xxxw
#define CS49300 B00000000  // @define CS49300| Multi Standard Audio Decoder Family 0000000w

// @define Definitionen fr die Chrontel-Bibliothek |
#define CH7002  B11101000  // @define CH7002| VGA-> PAL Decoder 111010xxw
#define ACH0          B10  // @define ACH0| Pin 36 des CH7002 auf 0
#define ACH1          B01  // @define ACH1| Pin 36 des CH7002 auf 1

// @define Definitionen fr die Dallas-Bibliothek |
#define DS75    B10010000  // @define DS75 | Temperatursensor 1001AAAw

// @define Definitionen fr die Dallas-Bibliothek |
#define LM75      B10010000  // @define DS75 | Temperatursensor 1001AAAw
#define LM75_TMP  B00000000  // @define LM75_TMP  | Adresse des Temperatur-Registers
#define LM75_CFG  B00000001  // @define LM75_CFG  | Adresse des Config-Registers
#define LM75_HYST B00000010  // @define LM75_HYST | Adresse des T-HYST-Registers
#define LM75_TOS  B00000011  // @define LM75_TOS  | Adresse des Config-Registers
#define SHUTDOWN  B00000001  // @define SHUTDOWN  | Adresse des Shutdown-Registers
#define CMP_INT   B00000010  // @define CMP_INT   | Adresse des Compare-/Int-Registers
#define OS_POL    B00000100  // @define OS_POL    | Adresse des O.S.Polarity-Registers
#define FAULT_1   B00000000  // @define FAULT_1   | Anzahl 1 Faults
#define FAULT_2   B00001000  // @define FAULT_2   | Anzahl 2 Faults
#define FAULT_4   B00010000  // @define FAULT_4   | Anzahl 4 Faults
#define FAULT_6   B00011000  // @define FAULT_6   | Anzahl 6 Faults


#endif
 
