//****************************************************************
// @doc
// @module CM517A.h | Enthlt alle Definitionen fr die Baugruppe
// CM517A der Firma Frenzel + Berg
// @end
//----------------------------------------------------------------
// Definitionen fuer MKS  !!
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Chip_inc/rcs/CM517A.h $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.1 $
// Datum:        $Date: 2001/06/10 09:26:30Z $
// Qualitt:     $State: Exp $
// Historie:
//==========
// $Log: CM517A.h $
// Revision 1.1  2001/06/10 09:26:30Z  MEBA
// Initial revision
//----------------------------------------------------------------

//***************************************************************
// Beschreibung: Allgemein
// Dieses H-File ist so aufgebaut, da alle bentigten Definitionen
// fr den jeweiligen Chip vorhanden sind. 
// Fr eine automatische Dokumentaion wird das Programm AUTODUCK
// eingesetzt.
// Das H-File kann beim C-Compiler als auch beim Assembler verwendet
// werden. (!! Versionen beachten !!)
// Beschreibung: Definitionen
//***************************************************************
//***************************************************************
#ifndef CM517A_H
  #define CM517A_H
//***************************************************************
// Definitionen ueber C-Compiler / Assembler
//***************************************************************
   #ifdef __C51__
     #if __C51__ < 602
      #error: !! ERROR, this files work only with the C-Compiler !!
      #error: !! Version 602 or higher !!
     #endif
   #endif
   #ifdef __A51__
     #if __A51__ < 601
      #error: !! ERROR, this files work only with the A51-Compiler !!
      #error: !! Version 602 or higher !!
     #endif
   #endif
#include <defines.h>
#include <REG517A.H>
#include <81C90.h>


//***************************************************************
// Angaben ueber die verwendete Baugruppe und dessen Umfeld
//***************************************************************
// @type Definitionen | Definitionen fr die Baugruppe phyCORE 591
#define MIKROPRO             _80517   // welcher Prozessor wird verwendet
#define SYSTEM_CLKHZ      16000000L   // Angabe in Hz
#define MACHINE_CYCLE             1   // Angabe in Sec 12 MHz Taktfrequenz
#define SYSTEM_CLK     SYSTEM_CLKHZ/1000000L  // Berechnung in MHz

// @define Definitionen von Adressen | 
#define CS_USER1    0xE300  // @define CS_USER1 | /CS-User1     Adresse (CM517A)
#define CS_USER2    0xE400  // @define CS_USER1 | /CS-User2     Adresse (CM517A)
#define CS_WDT      0xE000  // @define CS_USER1 | /CS-WDT       Adresse (CM517A)
#define CS_RTC      0xE200  // @define CS_USER1 | /CS-WDT       Adresse (CM517A)


// @define Definitionen der CAN-Anbindung |  
// @define USE_CAN | Bei Definition wird ein struct fr CAN-Controller angelegt.  
#ifdef USE_CAN
  struct SAE91C90_DEC xdata SAE91C90 _at_ 0xE100; 
#endif

// @define Definitionen der IC-Bus Anbindung |  
#define SDA_ADDRESS P5^5 // @define SDA_ADDRESS | Definition der der Portadresse fr SDA (LAB537) 
#define SCL_ADDRESS P5^6 // @define SCL_ADDRESS | Definition der der Portadresse fr SCL (LAB537) 

#endif
