//***************************************************************
// @doc
// @module 81C90.h | Enthlt alle Definitionen fr den CAN-Baustein
// SAE81C90.h
// @end
//----------------------------------------------------------------
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Chip_inc/rcs/81C90.h $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.1 $
// Datum:        $Date: 2001/02/03 09:49:02Z $
// Qualitt:     $State: Exp $
// Historie:
//==========
// $Log: 81C90.h $
// Revision 1.1  2001/02/03 09:49:02Z  MEBA
// Initial revision
//----------------------------------------------------------------

//***************************************************************
// Beschreibung: Allgemein
// Dieses H-File ist so aufgebaut, da alle bentigten Definitionen
// fr den jeweiligen Chip vorhanden sind. 
// Fr eine automatische Dokumentaion wird das Programm AUTODUCK
// eingesetzt.
// Das H-File kann beim C-Compiler als auch beim Assembler verwendet
// werden. (!! Versionen beachten !!)
// Beschreibung: Definitionen
// Auf die Register des 81C90 kann ber eine Struktur zugegriffen 
// werden.
//***************************************************************
//***************************************************************
#ifndef SAE91C90_H
  #define SAE91C90_H
//***************************************************************
// Definitionen ueber C-Compiler / Assembler
//***************************************************************
   #ifdef __C51__
     #if __C51__ < 602
      #error: !! ERROR, this files work only with the C-Compiler !!
      #error: !! Version 602 or higher !!
     #endif
   #endif
   #ifdef __A51__
     #if __A51__ < 601
      #error: !! ERROR, this files work only with the A51-Compiler !!
      #error: !! Version 602 or higher !!
     #endif
   #endif
#include <defines.h>
//***************************************************************
// Definitionen zum Chip
// @struct SAE91C90_DEC | 
//  Definitionen fuer alle zulaessigen Register im SAE91C90
//         
//***************************************************************
struct SAE91C90_DEC {
   uchar ucBL1;            // @field  
   uchar ucBL2;		       // @field 
   uchar ucOC;		       // @field
   uchar ucBRP;		       // @field
   uchar ucRR1;		       // @field
   uchar ucRR2;		       // @field
   uchar ucRIM1;	       // @field
   uchar ucRIM2;	       // @field
   uchar ucTRS1;	       // @field
   uchar ucTRS2;	       // @field
   uchar ucIMSK;	       // @field
   uchar aucDummy1[5];     // @field Feld zum freihalten
   uchar ucMOD;			   // @field
   uchar ucINT;			   // @field
   uchar ucCTRL;		   // @field
   uchar ucDummy2;		   // @field Feld zum freihalten
   uchar ucCC;			   // @field
   uchar ucTCEC;		   // @field
   uchar ucTCD;			   // @field
   uchar ucDummy3;		   // @field Feld zum freihalten
   uchar ucTRR1;		   // @field
   uchar ucTRR2;		   // @field
   uchar ucRRP1;		   // @field
   uchar ucRRP2;		   // @field
   uchar ucTSCH;		   // @field
   uchar ucTSCL;		   // @field
   uchar aucDummy4[10];	   // @field Feld zum freihalten
   uchar ucP0PDR;		   // @field
   uchar ucP0PR;		   // @field
   uchar ucP0LR;		   // @field
   uchar ucDummy5;		   // @field Feld zum freihalten
   uchar ucP1PDR;		   // @field
   uchar ucP1PR;		   // @field
   uchar ucP1LR;		   // @field
   uchar ucDummy6;		   // @field Feld zum freihalten
   uint  uiTimeStamp[8];   // @field
   uint  uiDescriptor[16]; // @field  uiDescriptor
}; 

#endif
