//***************************************************************
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Chip_inc/rcs/16550.h $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.1 $
// Datum:        $Date: 2001/02/03 09:36:05Z $
// Qualitt:     $State: Exp $
//***************************************************************
// Beschreibung: CAN-Baustein SAE81C90.H 
//***************************************************************
// Historie:
//==========
// $Log: 16550.h $
// Revision 1.1  2001/02/03 09:36:05Z  MEBA
// Initial revision
//***************************************************************
#ifndef PC16550_H
  #define PC16550_H
//***************************************************************
// Definitionen ueber C-Compiler / Assembler
//***************************************************************
   #ifdef __C51__
     #if __C51__ < 602
      #error: !! ERROR, this files work only with the C-Compiler !!
      #error: !! Version 602 or higher !!
     #endif
   #endif
   #ifdef __A51__
     #if __A51__ < 601
      #error: !! ERROR, this files work only with the A51-Compiler !!
      #error: !! Version 602 or higher !!
     #endif
   #endif
#include <defines.h>

#ifndef GLOBALS_H
  #include <globals.h>
#endif

// Baudraten Berechnung fuer den PC16550
#ifdef UART16550CLKHZ
	#define _1200_BAUD  (long)UART16550CLKHZ /(16 * 1200)
	#define _2400_BAUD  (long)UART16550CLKHZ /(16 * 2400)
	#define _4800_BAUD  (long)UART16550CLKHZ /(16 * 4800)
	#define _9600_BAUD  (long)UART16550CLKHZ /(16 * 9600)
	#define _19200_BAUD (long)UART16550CLKHZ /(16 * 19200)
#else
   #error: UART16550CLKHZ ist nicht in GLOBALS.h definiert worden.
   #error: Der Wert muss in Hz angegeben werden.
#endif
//***************************************************************
// Definitionen zum Chip
//***************************************************************
struct PC16550UART_DEC {
  union{
   uchar const ucRBR; // Addressbyte 0 RBR = Receive Buffer   Reg.
   uchar ucTHR;	      // Addressbyte 0 THR = Transmit Holding Reg.
   uchar ucDLL;       // Addressbyte 0 DLL = Divisor Latch (LS)
  }By0;

  union{
   uchar ucIER;       // Addressbyte 1 IER = Interrupt Enable Reg.
   uchar ucDLM;       // Addressbyte 1 DLM = Divisor Latch (MS)   
  }By1;

  union{
   uchar const ucIIR; // Addressbyte 2 IIR = Interrupt Ident  Reg.
   uchar ucFCR;       // Addressbyte 2 FCR = FIFO Control     Reg.
  }By2;

  uchar ucLCR;		  // Addressbyte 3 LCR = Line Control     Reg.
  uchar ucMCR;		  // Addressbyte 4 MCR = Modem Control    Reg.
  uchar ucLSR;		  // Addressbyte 5 LSR = Line Status      Reg.
  uchar ucMSR;        // Addressbyte 6 MSR = Modem Status     Reg.
  uchar ucSCR;		  // Addressbyte 7 SCR = Scratch          reg.   
}; 

// Definitionen fuer das Steuerregister MCR
#define  DTR    B00000001  // Signal DTR  setzen / ruecksetzen
#define  RTS    B00000010  // Signal RTS  setzen / ruecksetzen
#define OUT1    B00000100  // Signal OUT1 setzen / ruecksetzen
#define OUT2    B00001000  // Signal OUT2 setzen / ruecksetzen
#define LOOP    B00010000  // Starten des internen UART Tests

// Definitionen fuer das Steuerregister LSR
#define  DR     B00000001  // Signal Data Ready
#define  OE     B00000010  // Signal Overrun Error
#define  PE     B00000100  // Signal Parity Error
#define  FE     B00001000  // Signal Framing Error
#define  BI     B00010000  // Signal Break Interrupt
#define  THRE   B00100000  // Signal Transmitter Holding Register
#define  TEMT   B01000000  // Signal Transmitter Empty
#define  RCVE   B10000000  // Signal Receive FIFO Error

// Definitionen fuer das Steuerregister LCR
#define _5BIT   B00000000  // Definition der Baudrate 
#define _6BIT   B00000001  // Definition der Baudrate 
#define _7BIT   B00000010  // Definition der Baudrate 
#define _8BIT   B00000011  // Definition der Baudrate 

#define _2STOP   B00000100  // Definition der Baudrate 
#define NO_PAR   B00000000  // No Parity
#define ODD_PAR  B00001000  // Odd Parity
#define EV_PAR   B00011000  // Even Parity
#define ST_PAR   B00111000  // Stick Parity
#define SET_SOUT B01000000  // Direktes Setzen des SOUT
#define DLAB     B10000000  // Umschaltung Funktionsweise

#define NO_FIFO  B00000000  // Kein FIFO aktiviert

// Definitionen fuer das Steuerregister IER
#define ERBFI    B00000001  // Enable Received Data avialable
#define ETBEI    B00000010  // Enable Transmitter holding register empty
#define ELSI     B00000100  // Enable Receiver Line status
#define EDSSI    B00001000  // Enable Modem status interrupt
#endif
