/* Demo for the Olimex STM32-H103 (by Lanchon)
 * 
 * http://www.olimex.com/dev/stm32-h103.html
 * This demo may be compiled as C or C++. */

#include "stm32exceptions.h"
#include "stm32fwlib.h"

#define LED PERIPHERAL_BIT(GPIOC->ODR, 12)					// define pointers into the bit band area
#define BUTTON PERIPHERAL_BIT(GPIOA->IDR, 0)

void configureLed(void)										// configure GPIO pin for led (active low)
{
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOC, ENABLE);	// enable GPIOC clock
	*LED = 1;												// turn off led
	GPIO_InitTypeDef gpioi =								// configure PC12
	{
		GPIO_Pin_12,
		GPIO_Speed_10MHz,
		GPIO_Mode_Out_PP
	};
	GPIO_Init(GPIOC, &gpioi);
}

void configureButton(void)									// configure GPIO pin for button (active low)
{
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);	// enable GPIOA clock
	GPIO_InitTypeDef gpioi =								// configure PA0
	{
		GPIO_Pin_0,
		GPIO_Speed_10MHz,									// (this value is ignored for inputs)
		GPIO_Mode_IN_FLOATING
	};
	GPIO_Init(GPIOA, &gpioi);
}

void busyWait(volatile int count)							// delay by looping
{
	for (; count > 0; count--);								// (use volatile index to avoid optimization)
}

int main(void)
{
	#ifdef DEBUG
		debug();											// initialize the firmware library if needed
	#endif

	configureLed();											// configure GPIO pins for led and button
	configureButton();										// (both peripherals are active low)

	while (1)
	{
		*LED ^= 1;											// toggle led
		for (int i = 4; i > 0; i--)							// wait
		{
			busyWait(0x8000);
			if (!*BUTTON) break;							// if button is down cut the wait short
		}
	}
}

#ifdef CUSTOM_EXCEPTION_HANDLER
	void unexpected_exception(const char* name, int address)
	{
		while (1);											// user code here
	}
#endif

#ifdef DEBUG
	void assert_failed(u8* file, u32 line)
	{
		while (1);											// user code here
	}
#endif
