/************************************************************/
/* PROJECT NAME: AtoD	                                    */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin   tmartin@hitex.co.uk             */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     Keil ARM 	V1.3		                    */
/* Assembler:    				                            */
/*                                                          */
/************************************************************/
/* COPYRIGHT: Hitex UK Ltd 		2004						*/
/* LICENSE:   THIS VERSION CREATED FOR FREE DISTRIBUTION	*/
/************************************************************/
/* Function:                                                */
/*                                                          */
/* Example Analogue convertor program for LPC2100 			*/
/*															*/
/* Demonstrates A/Dconversion in hardware mode with 		*/
/*															*/	
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB2100								*/
/************************************************************/

#include <lpc21xx.h>

unsigned val = 0;

int main(void)
{

VPBDIV = 0x02;			//Set the Pclk to 30 Mhz
IODIR1 = 0x00FF0000;    // P1.16..23 defined as Outputs  
ADCR   = 0x00270601;    // Setup A/D: 10-bit AIN0 @ 3MHz 
ADCR  |= 0x01000000;    // Start A/D Conversion 

while(1)
{
		  
do
{
    val = ADDR;                   // Read A/D Data Register 
}        
while ((val & 0x80000000) == 0);  //Wait for the conversion to complete
val = ((val >> 6) & 0x03FF)<<16;  //Extract the A/D result 

IOCLR1 = ~val;  				  //write the result onto the LED pins
IOSET1 =  val;	 
}

}

 
