/************************************************************/
/* PROJECT NAME: SPI	                                    */
/* Engineer:    Eddie Mallon 	      						*/
/* Filename:    main.c          	                        */
/* Language:    C                   	   	                */
/* Compiler:    Keil ARM	V1.3		                    */
/* Function:    SPI Transmit example                        */
/* Demonstrates Transmitting a data byte over the SPI bus   */
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB21000								*/

/* note: P0.7 SSEL0 must be tied to vcc to enable Master 	*/

/************************************************************/

#include <LPC21xx.H> 

unsigned dly1 = 0; 
unsigned int adcval;
unsigned int spi_val;
unsigned int i;
unsigned int inc = 0;
unsigned int inc_val;

int main(void)
{
VPBDIV 		= 		0x00000003;			//Set PClk to 15Mhz
PINSEL0 	= 		0x00005500;			//Enable Pin 0.4,6,7 as SPI
IODIR1		=		0x00ff0000;
S0SPCCR		=		0x00000096;			//Set SPI clk to 98kHz
S0SPCR		=		0x00000078;			//Set SPI to master, LSB first, SCK active low.

while(1)
{
				

		S0SPDR		=		0x000000AA;
		do
		{
		spi_val 	= 		S0SPSR;             // Read SR register 
		}        
		while ((spi_val & 0x00000080) == 0); 	//Wait for the conversion to complete, data sent; check SR bit7 is 'Hi'
	
		IOSET1		=		S0SPDR;

		S0SPDR		=		0x000000F0;
		do
		{
		spi_val 	= 		S0SPSR;             // Read SR register 
		}        
		while ((spi_val & 0x00000080) == 0);

		IOSET1		=		S0SPDR;
}
}

