/************************************************************/
/* PROJECT NAME: GPIO	                                    */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin        tmartin@hitex.co.uk        */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     Keil ARM	V1.3		                    */
/* Assembler:    				                            */
/*                                                          */
/************************************************************/
/* COPYRIGHT: Hitex UK Ltd 		2004						*/
/* LICENSE:   THIS VERSION CREATED FOR FREE DISTRIBUTION	*/
/************************************************************/
/* Function:                                                */
/*                                                          */
/* Example 									           		*/
/*															*/
/* Demonstrates Use of the LPC2100 GPIO						*/
/*															*/	
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB21000								*/
/************************************************************/

#include <LPC21xx.H> 

void ChangeGPIOPinState(unsigned int state);


int main(void)
{
unsigned int delay;
unsigned int flasher = 0x00010000; 						// define locals

IODIR1 = 0x00FF0000; 									// set all ports to output

while(1)
{

for(delay = 0;delay<0x10000;delay++)				  //simple delay loop
{
;
}

ChangeGPIOPinState(flasher);							//set the state of the ports
flasher = flasher <<1;									//shift the active led
if(flasher&0x01000000) flasher = 0x00010000;			//Increment flasher led and test for overflow

}
}

void ChangeGPIOPinState(unsigned int state)
{
IOCLR1 = ~state;  										//clear output pins
IOSET1 =  state;											//set output pins

}


