/************************************************************/
/* PROJECT NAME: PWM	                                    */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin     tmartin@hitex.co.uk           */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     Keil ARM	V1.3		                    */
/* Assembler:    				                            */
/*                                                          */
/************************************************************/
/* COPYRIGHT: Hitex UK Ltd 		2004						*/
/* LICENSE:   THIS VERSION CREATED FOR FREE DISTRIBUTION	*/
/************************************************************/
/* Function:                                                */
/*                                                          */
/* 											      			*/
/*															*/
/* Demonstrates dual edge PWM generation					*/
/*															*/	
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB2100								*/
/************************************************************/

#include <LPC21XX.H>


  
int main(void)
{
unsigned val,delay;

PINSEL0 |= 0x000A8000;	//Enable pin 0.7   as PWM2 
PWMPR 	 = 0x00000001;	//Load prescaler

PWMPCR = 0x00005454;	//Set 3 channels of dual edge PWM
PWMMCR = 0x00000003;	//On match 0  reset the counter
PWMMR0 = 0x00000200;	//set PWM period to 0x200 ticks
PWMMR1 = 0x00000100;	//set rising edge of PWM2 to 0x100 ticks
PWMMR2 = 0x00000100;	//set falling edge of PWM2 to 0x100 ticks

PWMMR3 = 0x00000010;	//set rising edge of PWM2 to 2 ticks
PWMMR4 = 0x000000A0;	
PWMMR5 = 0x00000010;	//set rising edge of PWM2 to 2 ticks
PWMMR6 = 0x000000A0;

PWMLER = 0x0000007F;	//enable shadow latch for match 0 - 6 
PWMEMR = 0x02A0AA80;	//Match 1 and Match 2 outputs set high
PWMTCR = 0x00000002;	//Reset counter and prescaler 
PWMTCR = 0x00000009;	//enable counter and PWM, release counter from reset

ADCR   = 0x00250601;    // Setup A/D: 10-bit AIN0 @ 3MHz 
ADCR  |= 0x01000000;    // Start A/D Conversion 

while(1)				// main loop
{
for (delay=0;delay < 0x100;delay++)
{
;
}
do
{
    val = ADDR;                   // Read A/D Data Register 
}        
while ((val & 0x80000000) == 0);  //Wait for the conversion to complete
val = ((val >> 8) & 0x00FF);  //Extract the A/D result 

PWMMR1 = 0x00+val;
PWMMR2 = 0xFF-val;

PWMMR3 = 0x40-val;
PWMMR4 = 0x13F+val;

PWMMR5 = 0x80+val;
PWMMR6 = 0x17F-val;

PWMLER = 0x7E;

}
}



