/************************************************************/
/* PROJECT NAME: FIR	                                    */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin       tmartin@hitex.co.uk         */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     Keil ARM	V1.3		                    */
/* Assembler:    As  ARM port	                            */
/*                                                          */
/************************************************************/
/* COPYRIGHT: Hitex UK Ltd 		2004						*/
/* LICENSE:   THIS VERSION CREATED FOR FREE DISTRIBUTION	*/
/************************************************************/
/* Function:                                                */
/*                                                          */
/* Example Interrupt program for LPC2100           			*/
/*															*/
/* Demonstrates configuring a function as an ISR			*/
/*															*/	
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB2100								*/
/************************************************************/


#include <LPC21xx.H>
void fiqint (void) ;	   //declare FIQ ISR
void initFiq (void);

void main (void)
{

initFiq();											   //Initilise the Fast interrupt source

while(1)
{
IOCLR1 = 0x00FF0000;								  //Loop here forever
}

}

void fiqint (void)	__fiq
{
IOSET1 	= 0x00FF0000;								//Set the LED pins
EXTINT  = 0x00000002;								//Clear the peripheral interrupt flag

}

void initFiq(void) 
{
IODIR1			= 0x00FF0000;							//Set the LED pins as outputs
PINSEL0 		= 0x20000000;							//Enable the EXTINT1 interrupt
VICIntSelect 	= 0x00008000;							//Enable a Vic Channel as FIQ
VICIntEnable	= 0x00008000;		
}
