/***********************************************************************/
/*  This file is part of the uVision/ARM development tools             */
/*  Copyright KEIL ELEKTRONIK GmbH 2002-2004                           */
/***********************************************************************/
/*                                                                     */
/*  STARTUP.S:  Startup file                                           */
/*                                                                     */
/***********************************************************************/


/* 
//*** <<< Use Configuration Wizard in Context Menu >>> *** 
*/


// *** Startup Code (executed after Reset) ***


// Standard definitions of Mode bits and Interrupt (I & F) flags in PSRs

        Mode_USR  EQU      0x10
        Mode_FIQ  EQU      0x11
        Mode_IRQ  EQU      0x12
        Mode_SVC  EQU      0x13
        Mode_ABT  EQU      0x17
        Mode_UND  EQU      0x1B
        Mode_SYS  EQU      0x1F

        I_Bit     EQU      0x80    /* when I bit is set, IRQ is disabled */
        F_Bit     EQU      0x40    /* when F bit is set, FIQ is disabled */


/*
// <h> Stack Configuration
//   <o>  Top of Stack Address  <0x0-0xFFFFFFFF>
//   <h>  Stack Sizes (in Bytes)
//     <o1> Undefined Mode      <0x0-0xFFFFFFFF>
//     <o2> Supervisor Mode     <0x0-0xFFFFFFFF>
//     <o3> Abort Mode          <0x0-0xFFFFFFFF>
//     <o4> Fast Interrupt Mode <0x0-0xFFFFFFFF>
//     <o5> Interrupt Mode      <0x0-0xFFFFFFFF>
//     <o6> User/System Mode    <0x0-0xFFFFFFFF>
//   </h>
// </h>
*/
        Top_Stack       EQU     0x40004000
        UND_Stack_Size  EQU     0x00000004
        SVC_Stack_Size  EQU     0x00000004
        ABT_Stack_Size  EQU     0x00000004
        FIQ_Stack_Size  EQU     0x00000004
        IRQ_Stack_Size  EQU     0x00000080
        USR_Stack_Size  EQU     0x00000400


// Phase Locked Loop (PLL) definitions
        PLL_BASE        EQU     0xE01FC080  /* PLL Base Address */
        PLLCON_OFS      EQU     0x00        /* PLL Control Offset*/
        PLLCFG_OFS      EQU     0x04        /* PLL Configuration Offset */
        PLLSTAT_OFS     EQU     0x08        /* PLL Status Offset */
        PLLFEED_OFS     EQU     0x0C        /* PLL Feed Offset */
        PLLCON_PLLE     EQU     (1<<0)      /* PLL Enable */
        PLLCON_PLLC     EQU     (1<<1)      /* PLL Connect */
        PLLCFG_MSEL     EQU     (0x1F<<0)   /* PLL Multiplier */
        PLLCFG_PSEL     EQU     (0x03<<5)   /* PLL Divider */
        PLLSTAT_PLOCK   EQU     (1<<10)     /* PLL Lock Status */

/*
// <e> PLL Setup
//   <o1.0..4>   MSEL: PLL Multiplier Selection
//               <1-32><#-1>
//               <i> M Value
//   <o1.5..6>   PSEL: PLL Divider Selection
//               <0=> 1   <1=> 2   <2=> 4   <3=> 8
//               <i> P Value
// </e>
*/
        PLL_SETUP       EQU      1
        PLLCFG_Val      EQU      0x00000004


// Memory Accelerator Module (MAM) definitions
        MAM_BASE        EQU      0xE01FC000  /* MAM Base Address */
        MAMCR_OFS       EQU      0x00        /* MAM Control Offset*/
        MAMTIM_OFS      EQU      0x04        /* MAM Timing Offset */

/*
// <e> MAM Setup
//   <o1.0..1>   MAM Control
//               <0=> Disabled
//               <1=> Partially Enabled
//               <2=> Fully Enabled
//               <i> Mode
//   <o2.0..2>   MAM Timing
//               <0=> Reserved  <1=> 1   <2=> 2   <3=> 3
//               <4=> 4         <5=> 5   <6=> 6   <7=> 7
//               <i> Fetch Cycles
// </e>
*/
        MAM_SETUP       EQU      1
        MAMCR_Val       EQU      0x00000002
        MAMTIM_Val      EQU      0x00000004


// Starupt Code must be linked first at Address at which it expects to run.


AREA   STARTUPCODE, CODE, AT 0x00000000   // READONLY, ALIGN=4
       PUBLIC  __startup

       EXTERN  CODE32 (main)


__startup       PROC    CODE32

// Exception Vectors
// Mapped to Address 0.
// Absolute addressing mode must be used.
// Dummy Handlers are implemented as infinite loops which can be modified.

Vectors:        LDR     PC,=Reset_Addr         
                LDR     PC,Undef_Addr
                LDR     PC,SWI_Addr
                LDR     PC,PAbt_Addr
                LDR     PC,DAbt_Addr
                NOP                            /* Reserved Vector */
//              LDR     PC,IRQ_Addr
                LDR     PC,[PC, #-0x0FF0]     /* Vector from VicVectAddr */
                LDR     PC,FIQ_Addr

Reset_Addr:     DD      Reset_Handler
Undef_Addr:     DD      Undef_Handler
SWI_Addr:       DD      SWI_Handler
PAbt_Addr:      DD      PAbt_Handler
DAbt_Addr:      DD      DAbt_Handler
                DD      0                      /* Reserved Address */
IRQ_Addr:       DD      IRQ_Handler
FIQ_Addr:       DD      FIQ_Handler

Undef_Handler:  B       Undef_Handler
SWI_Handler:    B       SWI_Handler
PAbt_Handler:   B       PAbt_Handler
DAbt_Handler:   B       DAbt_Handler
IRQ_Handler:    B       IRQ_Handler
FIQ_Handler:    B       FIQ_Handler


// Reset Handler

Reset_Handler:  


IF (PLL_SETUP == 1)
                LDR     R0, =PLL_BASE
                MOV     R1, #0xAA
                MOV     R2, #0x55

// Configure and Enable PLL
                MOV     R3, #PLLCFG_Val
                STR     R3, [R0, #PLLCFG_OFS] 
                MOV     R3, #PLLCON_PLLE
                STR     R3, [R0, #PLLCON_OFS]
                STR     R1, [R0, #PLLFEED_OFS]
                STR     R2, [R0, #PLLFEED_OFS]

// Wait until PLL Locked
PLL_Loop:       LDR     R3, [R0, #PLLSTAT_OFS]
                ANDS    R3, R3, #PLLSTAT_PLOCK
                BEQ     PLL_Loop

// Switch to PLL Clock
                MOV     R3, #(PLLCON_PLLE | PLLCON_PLLC)
                STR     R3, [R0, #PLLCON_OFS]
                STR     R1, [R0, #PLLFEED_OFS]
                STR     R2, [R0, #PLLFEED_OFS]
ENDIF


IF (MAM_SETUP != 0)
                LDR     R0, =MAM_BASE
                MOV     R1, #MAMTIM_Val
                STR     R1, [R0, #MAMTIM_OFS] 
                MOV     R1, #MAMCR_Val
                STR     R1, [R0, #MAMCR_OFS] 
ENDIF


// Memory Mapping (when Interrupt Vectors are in RAM)
                MEMMAP  EQU  0xE01FC040  /* Memory Mapping Control */

#ifdef RAM_INTVEC
//.ifdef RAM_INTVEC
                LDR     R0, =MEMMAP
                MOV     R1, #2
                STR     R1, [R0]
#endif


// Initialise Interrupt System
// ...


// Setup Stack for each mode

                LDR     R0, =Top_Stack

// Enter Undefined Instruction Mode and set its Stack Pointer
                MSR     CPSR_c, #Mode_UND|I_Bit|F_Bit
                MOV     SP, R0
                SUB     R0, R0, #UND_Stack_Size

// Enter Abort Mode and set its Stack Pointer
                MSR     CPSR_c, #Mode_ABT|I_Bit|F_Bit
                MOV     SP, R0
                SUB     R0, R0, #ABT_Stack_Size

// Enter FIQ Mode and set its Stack Pointer
                MSR     CPSR_c, #Mode_FIQ|I_Bit|F_Bit
                MOV     SP, R0
                SUB     R0, R0, #FIQ_Stack_Size

// Enter IRQ Mode and set its Stack Pointer
                MSR     CPSR_c, #Mode_IRQ|I_Bit|F_Bit
                MOV     SP, R0
                SUB     R0, R0, #IRQ_Stack_Size

// Enter Supervisor Mode and set its Stack Pointer
                MSR     CPSR_c, #Mode_SVC|I_Bit|F_Bit
                MOV     SP, R0
                SUB     R0, R0, #SVC_Stack_Size

// Enter User Mode and set its Stack Pointer
                MSR     CPSR_c, #Mode_USR
                MOV     SP, R0

// Setup a default Stack Limit (when compiled with "-mapcs-stack-check")
                SUB     SL, SP, #USR_Stack_Size


// Relocate .data section (Copy from ROM to RAM)
#if 0  // TODO:  Zero init ?DT0? Segments
                LDR     R1, =_etext
                LDR     R2, =_data
                LDR     R3, =_edata
LoopRel:        CMP     R2, R3
                LDRLO   R0, [R1], #4
                STRLO   R0, [R2], #4
                BLO     LoopRel
#endif


#if 0  // TODO:  Zero init ?DT0? Segments
                MOV     R0, #0
                LDR     R1, =__bss_start__
                LDR     R2, =__bss_end__
LoopZI:         CMP     R1, R2
                STRLO   R0, [R1], #4
                BLO     LoopZI
#endif


// Enter the C code
                LDR     R0,=main
                TST     R0,#1       ; Bit-0 set: main is thumb
                LDREQ   LR,=exit?A  ; ARM Mode
                LDRNE   LR,=exit?T  ; Thumb Mode
                BX      R0
                ENDP

PUBLIC exit?A
exit?A          PROC    CODE32
                B       exit?A
                ENDP

PUBLIC exit?T
exit?T          PROC    CODE16
                B       exit?T
                ENDP


                END

