/************************************************************/
/* PROJECT NAME: CANRX	                                    */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin        tmartin@hitex.co.uk        */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     Keil ARM	V1.3		                    */
/* Assembler:    				                            */
/*                                                          */
/************************************************************/
/* COPYRIGHT: Hitex UK Ltd 		2004						*/
/* LICENSE:   THIS VERSION CREATED FOR FREE DISTRIBUTION	*/
/************************************************************/
/* Function:    CAN Transmit example                        */
/*                                                          */
/* Example 									           		*/
/*															*/
/* Demonstrates Transmiting a CAN packet				    */
/* 															*/
/*															*/
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB21000								*/
/************************************************************/

#include <LPC21xx.H> 
extern void InitCAN1(void);

int main(void)
{
unsigned val = 0;

VPBDIV 		= 		0x00000001;			//Set PClk to 60Mhz
ADCR   		= 		0x00270601; 		//Setup A/D: 10-bit AIN0 @ 3MHz 
ADCR 		|= 		0x01000000;			//Start A/D Conversion 
										

PINSEL1 	|= 		0x00014000;			//Enable Pin 0.25 as CAN1 RX
C2MOD 		= 		0x00000001;			//Set CAN controller into reset
C2BTR 		= 		0x001C001D;			//Set bit timing to 125k
C2MOD 		= 		0x00000000;			//Release CAN controller

InitCAN1();								 //initilise CAN controller 1 ( see next example)

while(1)
{

do
{
val 		= 		ADDR;				// Read A/D Data Register 
}		 
while ((val & 0x80000000) == 0);
										//A to D conversion 

if(C2SR & 0x00000004)					//See if Tx Buffer 1 is free
{
C2TFI1 		= 		0x00040000;			//Set DLC to 4 bytes 	
C2TID1 		= 		0x00000002;			//Set address to 2 Standard Frame
C2TDA1		=		val;				//Copy A/D result into first four bytes
C2CMR 		= 		0x00000021;			//Transmit the message
}
}

}


