/************************************************************/
/* PROJECT NAME: CANRX	                                    */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin        tmartin@hitex.co.uk        */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     Keil ARM	V1.3		                    */
/* Assembler:    				                            */
/*                                                          */
/************************************************************/
/* COPYRIGHT: Hitex UK Ltd 		2004						*/
/* LICENSE:   THIS VERSION CREATED FOR FREE DISTRIBUTION	*/
/************************************************************/
/* Function:    CAN receive example                         */
/*                                                          */
/* Example 									           		*/
/*															*/
/* Demonstrates the use of the Standard message acceptance  */
/* and receiving a CAN packet								*/
/*															*/
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB21000								*/
/************************************************************/


#include <LPC21xx.H> 

void CAN1IRQ (void)__irq;								//Declare the RX IRQ
void InitCAN1(void);

unsigned  int StandardFilter[2] 		_at_ 0xE0038000;	//Declare the standard acceptance filter table 
unsigned  int GroupStdFilter[2] 		_at_ 0xE0038008;
unsigned  int IndividualExtFilter[2]    _at_ 0xE0038010;
unsigned  int GroupExtFilter[2] 		_at_ 0xE0038018;


void InitCAN1(void)
{
IODIR1 				= 	0x00FF0000; 					// set all ports to output
PINSEL1 			|= 	0x00040000;						//Enable Pin 0.25 as CAN1 RX
C1MOD 				= 	0x00000001;						//Set CAN controller into reset
C1BTR 				= 	0x001C001D;						//Set bit timing to 125k
C1IER				=	0x00000001;						//Enable the Receive interrupt 
VICVectCntl0 		= 	0x0000003A;  					//select a priority slot for a given interrupt
VICVectAddr0 		= 	(unsigned)CAN1IRQ;				//pass the address of the IRQ into the VIC slot
VICIntEnable 		= 	0x04000000;						//enable interrupt
AFMR				=	0x00000001;						//Disable the Acceptance filters to allow setup of the table
StandardFilter[0]	=	0x20012002;
StandardFilter[1]	=	0x20032004;
SFF_sa				=	0x00000000;			 			//Set start address of Standard table
SFF_GRP_sa			=	0x00000008;						//Set start address of Standard group table
EFF_sa				=	0x00000008;						//Set start address of Extended table
EFF_GRP_sa			=	0x00000008;						//Set start address of Extended group table
ENDofTable			=	0x00000008;						//Set end of table address
AFMR				=	0x00000000;						//Enable Acceptance filters

C1MOD 				= 	0x00000000;						//Release CAN controller
}


void CAN1IRQ (void)	  __irq
{

IOCLR1 				= 	~C1RDA<<8;							//clear output pins
IOSET1 				=  	C1RDA<<8;							//set output pins
C1CMR 				=	0x00000004; 					//release the recieve buffer
VICVectAddr 		= 	0x00000000;						//Signal the end of interrupt
}

