/************************************************************/
/* PROJECT NAME: Thumb	                                    */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin       tmartin@hitex.co.uk         */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     Keil ARM	V1.3		                    */
/* Assembler:    				                            */
/*                                                          */
/************************************************************/
/* COPYRIGHT: Hitex UK Ltd 		2004						*/
/* LICENSE:   THIS VERSION CREATED FOR FREE DISTRIBUTION	*/
/************************************************************/
/* Function:                                                */
/*                                                          */
/* 										         			*/
/*															*/
/* Demonstrates configuration and use of the RTC			*/
/*															*/	
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB2100								*/
/************************************************************/

#include <LPC21xx.H> 

void clock(void);
void RTC_isr(void);
unsigned counter = 0;

int main(void)
{
VPBDIV			= 0x00000002;
IODIR1 			= 0x00FF0000; 						// set LED ports to output
IOSET1 			= 0x00020000;			
PREINT 			= 0x00000392;						//Set RTC prescaler for 12.000Mhz Xtal
PREFRAC 		= 0x00004380;
CIIR			= 0x00000001;						//Enable seconds counter interrupt
ALSEC			= 0x00000003;						//Set alarm register for 3 seconds
AMR				= 0x000000FE;						//Enable seconds Alarm
CCR 			= 0x00000001;						//Start the RTC

VICVectAddr13 	= (unsigned)RTC_isr; 				//Set the timer ISR vector address
VICVectCntl13 	= 0x0000002D;						//Set channel
VICIntEnable 	= 0x00002000;						//Enable the interrupt



while(1)
{
counter++;
}

}




void RTC_isr(void)	   __irq
{
unsigned led;


if(ILR&0x00000001)									//Test for RTC counter interrupt
{
	led 		= IOPIN1;							//read the current state of the IO pins
	IOCLR1 		=  led&0x00030000;					//Clear the illuminated LED
	IOSET1 		= ~led&0x00030000;					//Set the idle LED
	ILR 		= 0x00000001;						//Clear the interrupt register
}

if(ILR & 0x00000002)
{
	IOSET1 		= 0x00100000;						//Set LED 0.7
	ILR 		= 0x00000002;
}
VICVectAddr 	= 0x00000000;						//Dummy write to signal end of interrupt
}

