/************************************************************/
/* PROJECT NAME: Thumb	                                    */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin     tmartin@hitex.co.uk           */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     Keil ARM	V1.3		                    */
/* Assembler:    				                            */
/*                                                          */
/************************************************************/
/* COPYRIGHT: Hitex UK Ltd 		2004						*/
/* LICENSE:   THIS VERSION CREATED FOR FREE DISTRIBUTION	*/
/************************************************************/
/* Function:                                                */
/*                                                          */
/*															*/
/* Demonstrates Timer 0 match interrupt and simple PWM   	*/
/* modulation												*/	
/*															*/
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB2100								*/
/************************************************************/

#include <LPC21xx.H> 

void T0isr(void)	__irq;


int main(void)
{
VPBDIV	= 0x00000002;			// Configure the  VPB divi
						  	
PINSEL0 |= 0x00000800;			// Match1 as output
T0PR 	= 0x0000001E;			//Load prescaler
T0TCR 	= 0x00000002;			//Reset counter and prescaler
T0MCR 	= 0x00000003;			//On match reset the counter and generate an interrupt
T0MR0	= 0x00000010;			//Set the cycle time
T0MR1	= 0x0000000c;			// Set 50% duty cycle
T0EMR  	= 0x00000042;			//On match clear MAT1
T0TCR 	= 0x00000001;			//enable timer

VICVectAddr4 = (unsigned)T0isr;	//Set the timer ISR vector address
VICVectCntl4 = 0x00000024;		//Set channel
VICIntEnable |= 0x00000010;		//Enable the interrupt

while(1);
}

void T0isr (void)	__irq
{
T0EMR |= 0x00000002;			// Set MAT1 high for begining of the cycle
T0IR |= 0x00000001;				//Clear match 0 interrupt
VICVectAddr = 0x00000000;		//Dummy write to signal end of interrupt
}
