/*
; adcuart.c
;
; Demonstration program for reading AD converter of ADuC836EVB.
; Passing of defined thresholds is signalized by LED and buzzer.
; Po definovanom oneskoreni sa meni logicka uroven na vyvodoch
; Program is executed in infinite loop.
;
*/

#include <stdio.h>              // <  > denotes header files in system directory
#include <ADuC836.h>
#include "prevod.h"             // "  " denotes header files in project directory
#include "timer.h"              // function for delay

#define BZUCIAK T1
#define LED     T0                      // pin P3.4
#define POT_PRAH_ALARM          (1000)  // 1 V
#define POT_PRAH_CRITICAL       (2000)  // 2 V
#define LED_ON                     (1)  // see schematic
#define LED_OFF                    (0)
#define BZUCIAK_ON                 (0)
#define BZUCIAK_OFF                (1)


bit press_INT0( void )
{
bit tmp;
        INT0 = 1;               // force 1 in order to allow reading from pin
        do{
           tmp = INT0;          // reading of actual state of button
           delay( 20 );
        }
        while( tmp != INT0 );   // elimination of unstable state (oscillation)
        return tmp;             // reeturn button state (1=not activated, 0=activated)
}

void main (void)
{
 int temp;

// UART config (by using special timer T3 available on ADuC, see datasheet)
// T0, T1, T2 are available to application if necessary)
// Note that UART setting is disabled if monitor program is used as
// UART is already configured by monitor!!!)
//      T3CON = 0x82;
//      T3FD = 0x12;
//      SCON = 0x52;

        init_timer0();                            // timer initialization
        printf("_________________________________________\nAnalog Devices MicroConverter ADuC836 EVB\nAIN5 Reading Routine\n");
        printf("\Press button INTO to continue\n");

        while( press_INT0() )                     // waiting for button activation
                                ;
        printf("\OK - Button INTO activated!\n");

        while(1)
        {
            temp = 10*read_pot();                // approximately converted to mV
            if ( temp > POT_PRAH_ALARM )
                    LED = LED_OFF;               // switch off LEDky if higher than threshold 1
            else
                    LED = LED_ON;
            if (temp > POT_PRAH_CRITICAL)
                    BZUCIAK = BZUCIAK_ON;
            else
                    BZUCIAK = BZUCIAK_OFF;

            printf("\b\b\b\b\b\b\b\b%4d mV ", temp);  // output to UART
            delay( 200 );                        // delay 200 ms

        }
}
