; Demonstrating program for usage of the 8051 Timer and output to the external pin
;
; Nname of the program: GEN1MS
;
; Description:
;
; Program toggles pin P3.4 (this pin is conected to the LED of EVB board)
; with 1ms period. Period is determined by internal timer/counter T0.
; Timer T0 pis working in Mode 1 (16-bit counter).
;
;       To setting:
;
;       TMOD: GATE  C/T  M1  M0  GATE  C/T  M1  M0
;               X    X    X   X    0    0    0  1       Mode 1 of Timer T0
;
;       TCON:  TF1  TR1  TF0  TR0  IE1  IT1   IE0  IT0
;               x    x   x    0/1   x    x     x    x   on/off
;                                                       Timer T0
;
;       IE:     EA  ET2  ES  ET1  EX1  ET0  EX0
;               1    x   x    x    x    1    x          enable interrupt from 
;                                                       T0
;
;       Interrupt vector of T0 is at the address 000Bh.
;       State of the pin p3.4 is changed in the inettrupt
;
;       Periof of timer T0 je 500 us. For external 12 MHz crystal 
;       it requires initialization of T0: 65536-500=65036 (in decimal)
;
;
;       OBST0 - interrupt routine for T0 timer
;
;       MAIN  - main program, after timer T0 initialization ACC is incremented
;               in the endless loop (just demostration of some 
;               activity that can be done "in paralel" with interrupt routine)
;
; Autor:        M.Drutarovsky, TU Kosice
; Date:         02.11.2003
; Version:      1.01


#include "reg51.inc"            ; header file with definition of SFR and SBIT

        ORG 0                   ; starting addres of the program (after reset0

        JMP MAIN                ; jump "behind" interrupt vectors

        ORG 000BH               ; vector address of timer/counter T0
        JMP OBST0               ; jump to the interrupt handler code

;----------------------------------------------
; MAIN PROGRAM
;----------------------------------------------

        ORG 100H

MAIN:
        CALL INI_T0             ; T0 initialization and starting

        CLR  A                  ; initialization of ACC
KONIEC:
        INC  A                  ; "main program activity"
        JMP KONIEC              ; end (endles loop)

;----------------------------------------------
; SUBROUTINES
;----------------------------------------------


INI_T0:                         ; initialization of timer T0

        MOV TMOD,#00000001B     ; mode 1
        ORL IE  ,#10000010B     ; enable interrupt from T0
        MOV TH0,#HIGH(65036)    ; preset timer T0
        MOV TL0,#LOW(65036)
        SETB TR0                ; start timer T0
        RET

;----------------------------------------------

OBST0:
        CLR TR0                 ; stop Timer T0 (why?)
        MOV TH0,#HIGH(65036D)   ; restore preset value
        MOV TL0,#LOW(65036D)
        SETB TR0                ; start timer T0
        CPL P3.4                ; toggle pin state (LED diode on the EVB board)
        RETI                    ; return from the interrupt

        END