/*
; timer.c
;
; pouzitie casovaca pre definovanie oneskorenia
;
;
*/

#include <ADuC836.h>
#include "timer.h"

static volatile unsigned int cnt = 0;   // pocitadlo
                                        // static - viditelne len v tomto zdrojovom subore
                                        // volatile - pristup k premennej nebude optimalizovany

void timer0 (void) interrupt 1  // obsluha prerusenia casovaca 0
{
  TR0=0;                        // zastavenie casovaca T0
  TL0=PERIOD%256;               // definovanie periody
  TH0=PERIOD/256;
  TR0=1;                        // spustenie casovaca T0
  cnt++;                        // !!! pozor max. do 65565 ms
}


//----------------------------------------------
// inicializacia prerusenia
//----------------------------------------------

void init_timer0( void )
{
  TMOD=0x01;                    // mod 1 casovaca T0
  IE=0x82;                      // povolenie prerusenia od T0 a golbalneho prerusenia
  TL0=PERIOD%256;               // definovanie periody prerusenia
  TH0=PERIOD/256;
  TR0=1;                        // spustenie casovaca
}

void delay( unsigned char delay )
{
unsigned int cnt_tst;
        cnt_tst = cnt + delay;  // testovana hodnota = aktualna + pozadovane oneskorenie
        while( cnt < cnt_tst )  // definovane oneskorenie
                     ;          // cnt je volatile a teda nebude optimalizaciou zruesena
                                // caka sa pozadovany pocet preruseni
}
// aj ked uvedena implementacia sa zda byt "logicka", v skutocnosti je chybna. Po 65535 ms
// (t.j. priblizne po 1 minute) moze nastat "hazard". Predpokladajme, ze cnt = 65530 a
// pozadujeme oneskorenie 10 ms. Kedze cnt_tst je tiez len 16-bitova hodnota, je
// cnt_tst = (65530 + 10) mod 2^16 = 4 a plati cnt > cnt_tst a v slucke sa nebude cakat!!!.
// Pozadovane oneskorenie teda nebude 10 ms ale prakticky 0 ms!!!
// Podobne typy chyb je nutne v praxi osetrit, pretoze mozu zapricinovat "zahadne spravanie
// programu", ktore je velmi neprijemne detekovatelne. Samozrejme podobne rizika su
// aj pri programovani v jazyku asembler.
// Ako by ste upravili podprogram delay tak aby ste sa vyhli uvedenemu problemu?
