; Demonstracny program pre ovladanie LED diody a BZUCIAKA na vyvojovej doske
; ADuC836EB1 (kod upraveny pre simulacne prostredie Keil uVision).
;
; Nazov podprogramu: BLIKAC
;
; Opis:
;
; Po definovanom oneskoreni sa meni logicka uroven na vyvodoch
; T0 (P3.4) a T1. Program je realizovany v nekonecnej slucke.
; Na vyvodoch T0 a T1 vyvojovej dosky ADuC836EB1
; (http://www.kemt.fei.tuke.sk/Predmety/KEMT411_ESM/_materialy/EVB/ADuC836_Schema.pdf)
; je pripojena LED dioda (T0) resp. BZUCIAK (T1). Program zatial nie je
; mozne spustit na doske ADuC836EB1 a je precvicovany len v simulatore
; prostredia uVision.
;
; Program nici: r5, r6, r7
;
; Autor:          M.Drutarovsky, TU Kosice
; Datum:          15.10.2003
; Verzia:         1.0
; Poslena oprava: 2007-10-16, M.D.


        #include "reg51.inc" ; hlavickovy subor s definiciami SFR a SBIT

        org 8000h            ; zaciatok programu na adrese 8000h
        jmp start
; miesto medzi adresou 0h a start (1000h) je vynechane zamerne. V spodnej
; casti programovej pamate sa nachdzaju tzv. vektory preruseni, ktore
; budu preberane v dalsich tyzdnoch.


        org 9000h            ; DIREKTIVA zabezpeci, ze instrukcia
                             ; cpl p3.4 bude v pamati na adrese 9000h,
                             ; navestie start = 9000h.
start:  cpl p3.4             ; negovanie P3.4 (LED je na vyvode T0)
        cpl t1               ; negovanie T1 (BZuCIAK - pozri schemu ADuC836EB1)

        call wait            ; volanie podprogramu oneskorenia

start1: jmp start            ; nekonecna slucka

wait:   mov r7,#2            ; oneskorovacie slucky
w1:     mov r6,#50
w2:     mov r5,#0
w3:     djnz r5,w3
        djnz r6,w2
        djnz r7,w1
        ret
                             ; program "nikdy nekonci", pocas normalnej
                             ; cinnosti sa do thto bodu nikdy nedostane
        end                  ; DIREKTIVA konca asemblerovskeho programu.
