/*
; Demonstracny program pre ovladanie LED diody a BZUCIAKA na vyvojovej doske
; ADuC836EB1
;
; Nazov podprogramu: BLIKAC (jazyk C)
;
; Opis:
;
; Po definovanom oneskoreni sa meni logicka uroven na vyvodoch
; T0 a T1. Program je realizovany v nekonecnej slucke
; Samotny zdrojovy subor neurcuje poziciu kodu v pamati.
; Pozicia je nastavena v startovacom subore a nastaveni prostredia
; uVision
;
; Autor:        M.Drutarovsky, TU Kosice
; Date:         24.10.2003
; Verzia:       1.0
; Poslena oprava: 2007-10-16, M.D.
*/

#include <reg51.h>             // pouzivame len standardne registe 8051

typedef unsigned int uint;     // definicia noveho typu (vacsia prehladnost)

//----------------------------------------------------
// Programove oneskorenie (zavisle na hodnote krystalu)
//----------------------------------------------------
void oneskorenie( uint cnt) {  // uint je 16-bitova premenna (vlastnost Keil kompilatora)
  while ( cnt-- )              // ulozena v internej alebo externej pamati
        ;                      // (podla zvoleneho modelu SMALL, COMPACT, LARGE
}                              // definovanom v Options for Target ...-> Target

//----------------------------------------------
// HLAVNY PROGRAM
//----------------------------------------------

#define PAUZA   (5000)         // vacsia prehladnost s vyuzitim direktivy #define
#define BZUCIAK T1             // vyvod P3.5 (pozri reg51.h)
#define LED     T0             // vyvod P3.4

void main (void) {
  while(1) {                   // nekonecna slucka
     BZUCIAK = !BZUCIAK;       // zmena urovne signalu pre BZUCIAK
     LED = !LED;               // zmena urovne signalu pre LED
     oneskorenie( PAUZA );     // oneskorenie
  }
}

