//*****************************************************************************
// Copyright (c) 2006, Freescale Semiconductor
// Freescale Confidential Proprietary
// For use on Freescale products only.
//
// File name :   	emg_dynamic_http.c
// Project name: 	emg_HTTP web server for Coldfire
// Author:			Eric Gregori   (847) 651 - 1971
//
// Description : 	This file supports dynamic HTML using Tokens.
//					Dynamic HTML allows for dynamic content to reside
//					on a static HTML web page.
//
//*****************************************************************************
#include "ipport.h"
#include "tcpapp.h"
#include "menu.h"
#include "freescale_http_server.h"


extern const unsigned char 	*emg_static_ffs_ptrs[];
extern const unsigned short emg_static_ffs_len[];
extern const unsigned char 	emg_static_ffs_nof;
extern const unsigned long 	emg_static_ffs_type[];
extern const char 			*emg_static_ffs_filenames[];
extern int 					flash_erase( void *pio  );
extern int 					emg_http_var( void *pio  );
extern int 					emg_http_sessions( void *pio  );
extern int					sffs_erase( void *pio );
extern int					sffs_write( void *pio );
extern int					sffs_read( void *pio );

int emg_ffs_dir(void * pio);


//*****************************************************************************
// Fill out structure for EMG FFS DIRectory menu command
//*****************************************************************************
struct menu_op emg_ffs_dir_menu[] = 	{
											"EMG HTTP",  		stooges,			"EMG HTTP menu",
								   			"dir",    			emg_ffs_dir,    	"Dir of EMG FFS",
								   			"flash_erase",    	flash_erase,    	"Erase the dynamic FLASH area",
								   			"var",				emg_http_var,		"Dynamic HTML variable",
								   			"http",				emg_http_sessions, 	"Dump HTTP sessions array",
								   			"sffs_erase",       sffs_erase,         "Bulk Erase Serial Flash",
								   			"sffs_read",        sffs_read,          "Test read Serial Flash",
								   			"sffs_write",       sffs_write,         "Test write Serial Flash",
								   			NULL,
										};


//*****************************************************************************
// Print Directory of Static and Dynamic Flash File Systems.
//
// Author: Eric Gregori  (847) 651 - 1971
//		   eric.gregori@freescale.com
//*****************************************************************************
int emg_ffs_dir(void * pio)
{
	int   						file_count, total_file_size, k, j;
	volatile unsigned long		*fat_file_sys;
	volatile unsigned char		*fat_file_names;


	ns_printf( pio, "\nStatic FFS" );
	ns_printf( pio, "\n\n%-32s %-6s %-8s", 
					"FILENAME",
					"LENGTH",
					" POINTER" );

	total_file_size = 0;

	// Loop through each file printing the info
	for( file_count=0; file_count<emg_static_ffs_nof; file_count++ )
	{
		ns_printf( pio, "\n%-33s", emg_static_ffs_filenames[file_count] );
		ns_printf( pio, "%-9d", emg_static_ffs_len[file_count] );
		ns_printf( pio, "0x%-8x", (unsigned long)emg_static_ffs_ptrs[file_count] );			
		total_file_size += emg_static_ffs_len[file_count];
   	}

   	ns_printf(pio,"\n\n                                   Total Size = %d",total_file_size);
   	ns_printf(pio,"\ntotal static files = %d\n",file_count);

	ns_printf( pio, "\nDynamic FFS" );
	ns_printf( pio, "\n\n%-32s %-6s %-8s", 
					"FILENAME",
					"LENGTH",
					" POINTER" );

	total_file_size = 0;
	file_count		= 0;
	fat_file_sys 	= (unsigned long *)FAT_FILE_BASE_ADDR;
	if( fat_file_sys[0] == (unsigned long)'EMG1' )
	{
		// Use downloadable FFS
		// EMG1 ffs structures
		// typedef struct	{
		//						unsigned long	fatID;
		//						unsigned long	total_size_in_bytes;
		//						unsigned long	number_of_files;
		//						unsigned long	fat_pointer;
		//					}		FAT_HEADER;
		//
		// typedef struct	{
		//						unsigned long	file_pointer;
		//						unsigned long	file_size_in_bytes;
		//						unsigned long	file_type;
		//					}		FAT_FILE_DESCRIPTOR; 
		// 
		// After the header is a list of filenames
		fat_file_names = (unsigned char *)&fat_file_sys[4];
				
		// First char is 0
		j = 0;
		k = 0;				
		while(1)
		{
			// Scan to start of string
			// 2 consecutive NULL equals end
			for( ; fat_file_names[j]; j++ )
			{};
			if( fat_file_names[j+1] == 0 )
				break;
			
			j++;
			ns_printf( pio, "\n%-33s", &fat_file_names[j] );
			
			fat_file_sys 	= (unsigned long *)FAT_FILE_BASE_ADDR;
							
			// If found, K = index into FILE DESCRIPTORS
			// Set fat_file_sys to start of descriptors
			fat_file_sys = (unsigned long *)((unsigned long)fat_file_sys[3] + (unsigned long)FAT_FILE_BASE_ADDR);				

			// Index into descriptors, K is index
			// [0] = file pointer
			// [1] = file size
			// [2] = file type
			fat_file_sys = &fat_file_sys[k*3];

//			ns_printf( pio, "   %c   ", fat_file_sys[2] );
			ns_printf( pio, "%-9d", 	fat_file_sys[1] );
			ns_printf( pio, "0x%-8x", 	((unsigned long)fat_file_sys[0] + (unsigned long)FAT_FILE_BASE_ADDR) );			
			total_file_size += fat_file_sys[1];
			file_count++;
			k++;
		}
		
   		ns_printf(pio,"\n\n                                   Total Size = %d",total_file_size);
   		ns_printf(pio,"\ntotal dynamic files = %d\n",file_count);
		
	}

	ns_printf(pio,"\n\n" );
	
   	return 0;
}


//*****************************************************************************
// Form for blinking a LED.
//
// Author: Eric Gregori  (847) 651 - 1971
//		   eric.gregori@freescale.com
//*****************************************************************************
void form_led_function( char *data )
{
	if( data[6] == 'O' )
	{
		// LEDx_TOGGLE
		switch( data[3] )
		{
			case '1':
				LED0_TOGGLE;
				break;
							
			case '2':
				LED1_TOGGLE;
				break;

			case '3':
				LED2_TOGGLE;
				break;
							
			case '4':
				LED3_TOGGLE;
				break;
			
			default:
				break;
		}
	}

	if( data[6] == 'N' )
	{
		// LEDx_ON
		switch( data[3] )
		{
			case '1':
				LED0_ON;
				break;
							
			case '2':
				LED1_ON;
				break;

			case '3':
				LED2_ON;
				break;
							
			case '4':
				LED3_ON;
				break;
			
			default:
				break;
		}
	}

	if( data[6] == 'F' )
	{
		// LEDx_ON
		switch( data[3] )
		{
			case '1':
				LED0_OFF;
				break;
							
			case '2':
				LED1_OFF;
				break;

			case '3':
				LED2_OFF;
				break;
							
			case '4':
				LED3_OFF;
				break;
			
			default:
				break;
		}
	}		
}


//*****************************************************************************
// Form for outputing to serial.
//
// Author: Eric Gregori  (847) 651 - 1971
//		   eric.gregori@freescale.com
//*****************************************************************************
void form_serial_function( char *data )
{
	printf("%s", data );	
}


void skip_past_header( uint32 *data_pointer, uint32 *file_size )
{
	char 	*data;
	uint32 	index;
	uint32	count;
	
	index 	= 0;
	count	= 0;
	data 	= (char *)*data_pointer;
	for( index=0; index<*file_size; index++ )
	{
		if( (data[index] == 0x0D) || (data[index] == 0x0A) )
			count++;
		else
			count = 0;
		
		if( count == 4 )
			break;
	}
	
	if( count == 4 )
	{
		*file_size = *file_size - (index+1);
		*data_pointer = *data_pointer + (index+1);
	}	
}


//*****************************************************************************
// int emg_open( char *filename, uint32 *data_pointer, uint32 *file_size )
//
// User API to dynamic flash file system
//
// Finds the file descriptor in the FAT.
// Sets data_pointer to start of data.
// Sets file_size to size of file in bytes.  
// returns a < 0 if error, 0 = success
//
// for an example of using emg_open(), see cat command in menulib.c
// 
//
// Author: Eric Gregori  (847) 651 - 1971
//		   eric.gregori@freescale.com
//*****************************************************************************
int emg_open( char *filename, uint32 *data_pointer, uint32 *file_size )
{
	int   						k, j, found, i;
	volatile unsigned long		*fat_file_sys;
	volatile unsigned char		*fat_file_names;


	fat_file_sys 	= (unsigned long *)FAT_FILE_BASE_ADDR;
	if( fat_file_sys[0] == (unsigned long)'EMG1' )
	{
		// Use downloadable FFS
		// EMG1 ffs structures
		// typedef struct	{
		//						unsigned long	fatID;
		//						unsigned long	total_size_in_bytes;
		//						unsigned long	number_of_files;
		//						unsigned long	fat_pointer;
		//					}		FAT_HEADER;
		//
		// typedef struct	{
		//						unsigned long	file_pointer;
		//						unsigned long	file_size_in_bytes;
		//						unsigned long	file_type;
		//					}		FAT_FILE_DESCRIPTOR; 
		// 
		// After the header is a list of filenames
		fat_file_names = (unsigned char *)&fat_file_sys[4];
				
		// First char is 0
		j 		= 0;
		k 		= 0;
		found 	= 0;				
		while(1)
		{
			// Scan to start of string
			// 2 consecutive NULL equals end
			for( ; fat_file_names[j]; j++ ){};
			if( fat_file_names[j+1] == 0 )
				break;
			
			j++;
			
			// &fat_file_names[j] = start of filename
			if( strcmp( (char *)&fat_file_names[j], filename ) == 0 )
			{
				found = 1;
				break;				
			}
			
			k++;
		}
		
		if( found )
		{				
			fat_file_sys 	= (unsigned long *)FAT_FILE_BASE_ADDR;
							
			// If found, K = index into FILE DESCRIPTORS
			fat_file_sys = (unsigned long *)((unsigned long)fat_file_sys[3] + (unsigned long)FAT_FILE_BASE_ADDR);				

			// Index into descriptors, K is index
			// [0] = file pointer
			// [1] = file size
			// [2] = file type
			fat_file_sys = &fat_file_sys[k*3];

			*data_pointer = ((unsigned long)fat_file_sys[0] + (unsigned long)FAT_FILE_BASE_ADDR);
			*file_size    = (uint32)fat_file_sys[1];
			
			skip_past_header( data_pointer, file_size );
			return(0);
		}
	}

	// Static
	for( i=0, found=0; i<emg_static_ffs_nof; i++ )
	{
		for( j=0, k=0; filename[j]; j++ )
		{
			if( filename[j] == emg_static_ffs_filenames[i][k] )
				k++;		
		}
		
		if( emg_static_ffs_filenames[i][k] == 0 )
		{
			// Filename found
			found = 1;
			break;
		}
	}
	
	if( found )
	{
		*data_pointer = (unsigned long)emg_static_ffs_ptrs[i];
		*file_size    = emg_static_ffs_len[i];
		
		skip_past_header( data_pointer, file_size );
		return(0);
	}

	return(-1);
}


