//*****************************************************************************
// Copyright (c) 2006, Freescale Semiconductor
// Freescale Confidential Proprietary
// For use on Freescale products only.
//
// File name :   	freescale_flash_loader.c
// Project name: 	emg_HTTP web server for Coldfire
// Author:			Eric Gregori   (847) 651 - 1971
//		   			eric.gregori@freescale.com
//
// Description : 	This is the flash driver for the Coldfire 5223X flash.
//
//*****************************************************************************
#include "common.h"
#include "ipport.h"
#include "tcpapp.h"
#include "menu.h"
#include "freescale_http_server.h"

/* Mask codes */
#define ACCERR		0x10
#define PVIOL		0x20
#define CCIF		0x40
#define CBEIF		0x80

extern void mcf5xxx_irq_disable( void );
extern void mcf5xxx_irq_enable( void );
extern void init_serial_flash( void );	


void Flash_Init(unsigned long FlashClk);
int flash_erase( void *pio  );
void SpSub(void); 
void SpSubEnd(void);

//*****************************************************************************
// Fill out structure for EMG FFS DIRectory menu command
//*****************************************************************************
struct menu_op flash_erase_menu[] = 
							{
									"EMG FFS",        stooges,			"EMG FFS menu",
								   	NULL,
							};


//
// Flash drivers and downloading
//
// 15.4.3.2 Program, Erase, and Verify Sequences
// A command state machine is used to supervise the write sequencing of program, erase, and verify
// commands. To prepare for a command, the CFMUSTAT[CBEIF] flag should be tested to ensure that the
// address, data, and command buffers are empty. If CBEIF is set, the command write sequence can be
// started.
//
// This three-step command write sequence must be strictly followed. No intermediate writes to the CFM
// module are permitted between these three steps. The command write sequence is:
// 1. Write the 32-bit longword to be programmed to its location in the CFM array. The address and data
// will be stored in internal buffers. All address bits are valid for program commands. The value of
// the data written for verify and erase commands is ignored. For mass erase or verify, the address can
// be any location in the CFM array. For page erase, address bits [9:0] are ignored.
//
// NOTE
// The page erase command operates simultaneously on adjacent erase pages
// in two interleaved Flash physical blocks. Thus, a single erase page is
// effectively 2 Kbyte.
// 2. Write the program, erase, or verify command to CFMCMD, the command buffer. See
// Section 15.4.3.3, Flash Valid Commands.
// 3. Launch the command by writing a 1 to the CBEIF flag. This clears CBEIF. When command
// execution is complete, the Flash state machine sets the CCIF flag. The CBEIF flag is also set
// again, indicating that the address, data, and command buffers are ready for a new command
// sequence to begin.
// The Flash state machine flags errors in command write sequences by means of the ACCERR and PVIOL
// flags in the CFMUSTAT register. An erroneous command write sequence self-aborts and sets the
// appropriate flag. The ACCERR or PVIOL flags must be cleared before commencing another command
// write sequence.
void flash_init_old( void )
{
	// So, for fSYS = 66 MHz, writing 0x54 to CFMCLKD will set fCLK to 196.43 kHz which is a valid frequency
	// for the timing of program and erase operations.
	// WARNING
	// For proper program and erase operations, it is critical to set fCLK between
	// 150 kHz and 200 kHz. Array damage due to overstress can occur when fCLK
	// is less than 150 kHz. Incomplete programming and erasure can occur when
	// fCLK is greater than 200 kHz.
	MCF_CFM_CFMCLKD = 0x54;
	init_serial_flash();	
}


//*****************************************************************************
// Flash page erase function.
//
// Author: Eric Gregori  (847) 651 - 1971
//		   eric.gregori@freescale.com
//*****************************************************************************
volatile void flash_page_erase( unsigned long *address, unsigned long data )
{
	char buf[100];//Local space on stack do not move or change
	int (*DoOnStack)(void) = (int(*)(void))buf;
	memcpy(buf, (void*)SpSub, (char*)SpSubEnd - (char*)SpSub);

//	mcf5xxx_irq_disable();
	
	*address = data;
	
	MCF_CFM_CFMCMD = 0x40;
	DoOnStack();
	
//	MCF_CFM_CFMUSTAT = 0x80;
	
//	while( !(MCF_CFM_CFMUSTAT & MCF_CFM_CFMUSTAT_CCIF))
//	{};
		
//	mcf5xxx_irq_enable();		
}


//*****************************************************************************
// Flash write function.
//
// Author: Eric Gregori  (847) 651 - 1971
//		   eric.gregori@freescale.com
//*****************************************************************************
volatile void flash_write( unsigned long *address, unsigned long data )
{
	char buf[100];//Local space on stack do not move or change
	int (*DoOnStack)(void) = (int(*)(void))buf;
	memcpy(buf, (void*)SpSub, (char*)SpSubEnd - (char*)SpSub);

//	mcf5xxx_irq_disable();
	
	*address = data;
	
	MCF_CFM_CFMCMD = 0x20;
	DoOnStack();
	
//	MCF_CFM_CFMUSTAT = 0x80;
	
//	while( !(MCF_CFM_CFMUSTAT & MCF_CFM_CFMUSTAT_CCIF))
//	{};
		
//	mcf5xxx_irq_enable();		
}


//*****************************************************************************
// Flash test function, used to erase flash for demo
//
// Author: Eric Gregori  (847) 651 - 1971
//		   eric.gregori@freescale.com
//*****************************************************************************
int flash_erase( void *pio  )
{
	unsigned long	address;


	flash_init_old();
	Flash_Init(SYSTEM_CLOCK*1000/2);	
	for( address = FLASH_START_ADDRESS; address < FLASH_END_ADDRESS; address += FLASH_PAGE_SIZE )
		flash_page_erase( (unsigned long *)address, (unsigned long)0 );

	return(0);
}

//*****************************************************************************
//* Function Name	: SpSub
//* Description 	: All that is require to launch flash commands from
//*                   SRAM. All else can be in flash.A better man might
//*					  be able to reduce from 52 bytes.Also might add a 
//*					  feature timeout.
//*
//*****************************************************************************
void SpSub(void) 
{
	asm(
		//	mcf5xxx_irq_disable();
		move.w  SR,D7       	/* current sr    */
		move.l  D7,D5       	/* save return value  */
		move.w  #0x0700,D6      /* set level to 7    */
		andi.l  #0x0000F8FF,D7  /* zero out current IPL  */
		or.l    D6,D7           /*    */
		move.w  D7,SR           /* place new IPL in sr   */

		//	MCF_CFM_CFMUSTAT = CBEIF;
		move.l   #MCF_CFM_CFMUSTAT,a4  
		move.b   #0x80,d1     
		move.b   d1,(a4)

		//	while (!(MCF_CFM_CFMUSTAT & CCIF)){};//wait until execution complete
		loop:
		move.l   #MCF_CFM_CFMUSTAT,a4  
		move.b   (a4),d2
		moveq    #0,d1
		move.b   d2,d1
		andi.l   #0x40,d1     
		beq.s    loop

		//	mcf5xxx_irq_enable();
		move.w  D5,SR
	);
}
void SpSubEnd(void){} // leave this immediately after SpSub
//*****************************************************************************
//* Function Name	: Flash_Init
//* Description 	: Initialize Flash NVM for programming
//* 			      FCLKDIV based on passed sys/2 (FlashClk) frequency, then
//*			          uprotect the array, and finally ensure PVIOL and 
//*			          ACCERR are cleared by writing to them.
//*
//*****************************************************************************
void Flash_Init(unsigned long FlashClk)
{
unsigned char fclk_val;
	
if ((MCF_CFM_CFMCLKD && MCF_CFM_CFMCLKD_DIVLD) != 1)
	{
	/* Next, initialize FCLKDIV register to ensure we can program/erase */
		if (FlashClk >= 12000) {
			fclk_val = (unsigned char)(FlashClk/8/200 - 1); /* FDIV8 set since above 12MHz clock */
			MCF_CFM_CFMCLKD |= fclk_val | MCF_CFM_CFMCLKD_PRDIV8;
		}
		else
		{
			fclk_val = (unsigned char)(FlashClk/200 - 1);
			MCF_CFM_CFMCLKD |= fclk_val;
		}
	}

	MCF_CFM_CFMPROT = 0x00; /* Disable all protection (if LOCK not set)*/
	MCF_CFM_CFMUSTAT |= (PVIOL|ACCERR);/* Clear any errors  */
}
