//*****************************************************************************
// Copyright (c) 2006, Freescale Semiconductor
// Freescale Confidential Proprietary
// For use on Freescale products only.
//
// File name :   	emg_dynamic_http.c
// Project name: 	emg_HTTP web server for Coldfire
// Author:			Eric Gregori   (847) 651 - 1971
//
// Description : 	This file supports dynamic HTML using Tokens.
//					Dynamic HTML allows for dynamic content to reside
//					on a static HTML web page.
//
//*****************************************************************************
#include "ipport.h"
#include "tcpapp.h"
#include "menu.h"
#include "freescale_http_server.h"


extern int poll_switches( void );
extern short read_AD( int channel );


#define UINT8		unsigned char


UINT32	html_vars[MAX_NUMBER_OF_VARS];
UINT8	html_vars_flags[MAX_NUMBER_OF_VARS];
UINT32	hit_counter = 0;


//*****************************************************************************
// Convert ascii hex byte to binary.
//
// Author: Eric Gregori  (847) 651 - 1971
//		   eric.gregori@freescale.com
//*****************************************************************************
static UINT8	asciihextobin( UINT8 ascii )
{
	if( ascii > 0x39 )
	{
		if( ascii > 0x46 )
		{
			// lower case letters
			return( (ascii-0x61) + 0x0a);
		}
		
		// uppercase letters
		return( (ascii-0x41) + 0x0a);
	}
	
	// numbers
	return( ascii-0x30 );
}


//*****************************************************************************
// Process length bytes in the buffer body_buff.
// Synchronize with token, and semicolon at end of command.
// The buffer of size length, MUST include both the token and semicolon.
//
// The buffer MUST be in RAM.
//
// Author: Eric Gregori  (847) 651 - 1971
//		   eric.gregori@freescale.com
//*****************************************************************************
void replace_with_sensor_data( char *body_buff, UINT32 length )
{
	UINT32	i, command_length, multiplier, compare_const;
	UINT8	index, j, replace, k, copy;


#if HTTP_VERBOSE>5
	printf( "\nTOKEN" );
#endif
	for( i=0; i<length; i++ )
	{
		// Process sensor data request 
		// ~IIF;  
		// where 
		//		I  	= Variable Index
		//		F	= Format ( H=hex, D=decimal
		if( body_buff[i] == DYNAMIC_REPLACE_TOKEN )
		{
			for( j=0, command_length=0; j<(length-i); j++ )
			{
				if( body_buff[i+j+1] == DYNAMIC_EOS_TOKEN )
				{
					command_length = j;
					break;
				}
			}

			if( command_length >= 3 )
			{
				index = (((body_buff[i+1]-0x30) * 10)  +
						(body_buff[i+2]-0x30) );
#if HTTP_VERBOSE>5
				printf( "\nindex=%d", index );
#endif
				if( index < MAX_NUMBER_OF_VARS )
				{
					if( html_vars_flags[index] )
					{
						if( body_buff[i+3] == 'H' )
						{
							// clear under token
							for( j=0; j<(command_length+2); j++ )
								body_buff[i+j] = ' ';

							// output data to bodybuff in Hex
							j = sprintf( (char *)&body_buff[i], "%x", html_vars[index] );
							body_buff[i+j] = ' ';
						}
						else
						{
							// clear under token
							for( j=0; j<(command_length+2); j++ )
								body_buff[i+j] = ' ';
					
							// output data to bodybuff in decimal
							j = sprintf( (char *)&body_buff[i], "%d", html_vars[index] );
							body_buff[i+j] = ' ';							
						}
					}
					else
					{
						for( j=0; j<(command_length+2); j++ )
							body_buff[i+j] = ' ';						
					}
				}
			}
		}

		// Process conditional sensor read
		// ^II>C|true||false|;
		// where
		//		I   = Variable Index
		//		C   = hex value for comparison
		//		>   = variable value greater then C
		//		=   = variable value equal to C
		//		&	= variable value and C
		//		!	= !variable value and C
		//		"true"  = ascii string to replace if true
		//		"false" = ascii string to replace if false
		if( body_buff[i] == DYNAMIC_COMPARE_TOKEN )
		{
			if( (body_buff[i+3] == '=' ) || 
				(body_buff[i+3] == '>')  ||
				(body_buff[i+3] == '&')  )
			{				
				// measure length of Comparison Field		
				for( j=0, command_length=0; j<(length-i); j++ )
				{
					if( (body_buff[i+j+4] == '|') )
					{
						command_length = j;
						break;
					}
				}
#if HTTP_VERBOSE>5				
				printf( "\nCompare length = %d", command_length );
#endif				
				if( command_length && (command_length<=8) )
				{
					// compare field > 1 character
					multiplier 		= 0x00000001 << ((command_length-1)*4);
					compare_const 	= 0;
					for( j=0;command_length; command_length--, j++)
					{
						compare_const += (multiplier * asciihextobin(body_buff[i+4+j]));
						multiplier >>= 4;						
					}
#if HTTP_VERBOSE>5					
					printf( "  compare constant = %x", compare_const );					
#endif
				}

				for( j=0, command_length=0; j<(length-i); j++ )
				{
					if( body_buff[i+j+1] == DYNAMIC_EOS_TOKEN )
					{
						command_length = j;
						break;
					}
				}

				if( command_length >= 2 )
				{
					index = (((body_buff[i+1]-0x30) * 10)  +
							(body_buff[i+2]-0x30) );
#if HTTP_VERBOSE>5
					printf( "   index=%d", index );
#endif
					if( index < MAX_NUMBER_OF_VARS )
					{

						replace = 0;
						if( body_buff[i+3] == '>' )
						{
							if( html_vars[index] > compare_const )
								replace = 1;
							else
								replace = 2;
						}

						if( body_buff[i+3] == '=' )
						{
							if( html_vars[index] == compare_const )
								replace = 1;
							else
								replace = 2;
						}
				
						if( body_buff[i+3] == '&' )
						{
							if( html_vars[index] & compare_const )
								replace = 1;
							else
								replace = 2;
						}

						// measure length of complete token		
						for( j=0, command_length=0; j<(length-i); j++ )
						{
							if( (body_buff[i+j] == '|') && (body_buff[i+j+1] == DYNAMIC_EOS_TOKEN) )
							{
								command_length = j;
								break;
							}
						}
				
						if( command_length )
						{
#if HTTP_VERBOSE>5
							printf( " replace=%d", replace );
#endif
							if( replace == 1 )
							{
								// Scan to first quote then copy everything to next quote
								for( j=0, k=0, copy=0; j<command_length; j++ )
								{
									if( body_buff[i+j] == '|' )
									{
										if( !copy )
											copy = 1;
										else
											break;
									}
									else if( copy )
									{
										body_buff[i+k] = body_buff[i+j];
										k++;
									}
								}
							}

							if( replace == 2 )
							{
								// Scan to third quote then copy everything to next quote
								for( j=0, k=0, copy=0; j<command_length; j++ )
								{
									if( body_buff[i+j] == '|' )
										copy++;
									else if( copy == 2 )
									{
										body_buff[i+k] = body_buff[i+j];
										k++;
									}

									if( copy == 3 )
										break;
								}
							}

							// Fill in to end with spaces
							if( replace )
							{
								for( ; k<(command_length+2); k++ )
									body_buff[i+k] = ' ';
							}
						}
					}
				}
			}
		}
	}
}


//*****************************************************************************
// Fill the dynamic HTML variable array with sensor data.
// For this demo, the sensor data is entered via the command line/serial port.
// There are two entries for each variable.  The flag variable determines if the
// entry is valid.  A invalid entry is displayed as a "---"
// When the entry is valid, the data is 32 bits.
//
// When we get the RTC, and switch drivers, we can use them here to fill out
// the array.
//
// Author: Eric Gregori  (847) 651 - 1971
//		   eric.gregori@freescale.com
//*****************************************************************************
void collect_sensor_data( void )
{
	html_vars[0] 		= MCF_GPIO_PORTTC;
	html_vars_flags[0] 	= 1;

	html_vars[1] 		= poll_switches();
	html_vars_flags[1] 	= 1;

	html_vars[2]		= hit_counter++;
	html_vars_flags[2] 	= 1;

	html_vars[3]		= read_AD(0);
	html_vars_flags[3] 	= 1;

	html_vars[4]		= read_AD(1);;
	html_vars_flags[4] 	= 1;

	html_vars[5]		= 0;
	html_vars_flags[5] 	= 1;

	html_vars[6]		= 0;
	html_vars_flags[6] 	= 1;

	html_vars[7]		= read_AD(4);
	html_vars_flags[7] 	= 1;

	html_vars[8]		= read_AD(5);
	html_vars_flags[8] 	= 1;

	html_vars[9]		= read_AD(6);
	html_vars_flags[9] 	= 1;

	html_vars[10]		= 0;
	html_vars_flags[10] 	= 1;

	html_vars[11]		= (MCF_RTC_HOURMIN & 0x00001F00)>>8;
	html_vars_flags[11] 	= 1;

	html_vars[12]		= MCF_RTC_HOURMIN & 0x0000003F;
	html_vars_flags[12] 	= 1;

	html_vars[13]		= MCF_RTC_SECONDS & 0x0000003F;
	html_vars_flags[13] 	= 1;
}

//*****************************************************************************
// Provide a serial command to set Dynamic HTML variables.
// VAR 			- Displays all variable values
// VAR II		- Displays variable value
// VAR II, DDDD - Sets variable value
//
// Author: Eric Gregori  (847) 651 - 1971
//		   eric.gregori@freescale.com
//*****************************************************************************
int emg_http_var( void *pio  )
{
	int		index,i,data;
   	char 	*arg =  nextarg(((GEN_IO)pio)->inbuf);
   	char 	*next;


	collect_sensor_data();

   	if (!arg || !*arg)   /* no arg given */
   	{
		ns_printf(pio, "\n\nDynamic HTML variable dump" );
		for( i=0; i<MAX_NUMBER_OF_VARS; i++ )
		{
			if( html_vars_flags[i] )
			{
				ns_printf(pio, "\nVariable %d = %d   %x", i, html_vars[i], html_vars[i] );
			}
		}

		ns_printf(pio, "\n\n" );	
      	return(0);
   	}

   	next = nextcarg(arg);
   	if (!next)
   	{   	
   	   	index = atoi(arg);
   	   	if( index < MAX_NUMBER_OF_VARS )
			ns_printf(pio, "\nVariable %d = %d   %x", index, html_vars[index], html_vars[index] );		
   	}
	else
	{
	   	index = atoi(arg);
		data = atoi(next);
	
		if( index < MAX_NUMBER_OF_VARS )
		{
			html_vars_flags[index] = 1;
			html_vars[index]       = data;	
		}		
	}

	ns_printf(pio, "\n\n" );
	return(0);   
}