/* tftpcli.c
 *
 * Copyright 1997- 2006 By InterNiche Technologies Inc. All rights reserved
 *
 * Portions Copyright 1986 by Carnegie Mellon
 * Portions Copyright 1984 by the Massachusetts Institute of Technology
 *
 * Copyright (c) 1982, 1986, 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation and other 
 * materials related to such distribution and use acknowledge that 
 * the software was developed by the University of California, Berkeley.
 * The name of the University may not be used to endorse or promote 
 * products derived from this software without specific prior written 
 * permission. THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *
 * Rights, responsibilities and use of this software are controlled by
 * the agreement found in the "LICENSE.H" file distributed with this
 * source code.  "LICENSE.H" may not be removed from this distribution,
 * modified, enhanced nor references to it omitted.
 *
 *   TFTP client code - uses common code in tftputil.c and udp
 * interface in tftpudp.c
 *
 */

#include "license.h"
#include "tftpport.h"

#ifdef TFTP_CLIENT

#include "tftp.h"


/* tftpuse() - Entry point for tftp transfers.

   Called from app to initiate a tftp transfer.

Retuns NULL if transer started without errors, else returns a pointer 
to text describing the error.
*/

char * 
tftpuse(
   ip_addr fhost,   /* address of foriegn tftp host */
   char *fname,   /* name of file on this machine */
   char *rmfile,   /* name of file on other machine */
   unsigned dir,   /* transfer direction, either PUT or GET */
   unsigned mode,   /* binary or ascii file transfer */
   int (*callback)(int, struct tfconn*, char*) )   /* callback */
{
struct tfconn * cn;

   cn = tfmkcn();
   if(cn == NULL)
      return("alloc failed");

   cn->tf_mode = mode;
   cn->tf_start = cticks;
   cn->tf_fhost = fhost;
   cn->tf_dir = dir;
   cn->tf_mode = mode;
   cn->tf_fport = TFTPPORT;
   cn->tf_lport = 0;          /* let tftp_udplisten() assign port */
   cn->tf_fhost = fhost;
   cn->callback = callback;

   /* Open client tftp connection. Note that foreign port is wildcard
   since server will select it's own when it replys */
   cn->tf_conn = tftp_udplisten(cn->tf_fhost, 0, &cn->tf_lport, 
                  (void*)cn);
   if(!cn->tf_conn)
      return("Couldn't open UDP connection");

   if(dir == GET) 
   {
      if(mode == ASCII)
         cn->tf_fd = vfopen(fname, "w");
      else if(mode == OCTET)
         cn->tf_fd = vfopen(fname, "wb");
      else 
         return("Invalid mode");

      if(cn->tf_fd == 0)
      {
         cn->tf_state = DEAD;
         return("Couldn't open local file");
      }
      if(tfsndreq(cn, rmfile) != 0)
         return "Initial request failed";
      cn->tf_expected = 1;
      cn->tf_state = DATAWAIT;
   }
   else if(dir == PUT)
   {
      if(mode == ASCII)
         cn->tf_fd = vfopen(fname, "r");
      else if(mode == OCTET)
         cn->tf_fd = vfopen(fname, "rb");
      else 
         return("Invalid mode");

      if(cn->tf_fd == 0)
         return("Couldn't open file to send");

      if(tfsndreq(cn, rmfile) != 0)
         return "Initial request failed";
      cn->tf_expected = 0;
   }
   else   /* not tftp PUT or GET? */
   {
      dtrap();   /* prog error */
      return ("bad direction parm");
   }
   return NULL;
}

/* Format up and send out an initial request for a tftp transfer. */

int
tfsndreq(struct tfconn * cn, char * fname)
{
int err;
int reqlen;    /* length of tftp request data */
TFTPBUF p;
struct tfreq *ptreq;
char *cp;

   /* calculate request length: 
    *   size of request header
    *   + length of filename in octets
    *   + two zero octets
    *   + length of mode string
    */
   reqlen = sizeof(struct tfreq) + strlen(fname) + 2;
   if(cn->tf_mode == OCTET)
      reqlen += 5;   /* for "octet" */
   else if(cn->tf_mode == ASCII)
      reqlen += 8;   /* for "netascii" */
   else
   {
      dtrap();   /* bad mode; prog error */
      return FALSE;
   }

   tftp_udpbuffer(cn, reqlen);
   if(cn->tf_outbuf.data == NULL)
      return ENP_NOBUFFER;
   p = &cn->tf_outbuf;
   ptreq = (struct tfreq *)p->data;

   if(cn->tf_dir == GET) 
      ptreq->tf_op = TF_RRQ;
   else if(cn->tf_dir == PUT) 
      ptreq->tf_op = TF_WRQ;
   else 
   {
      dtrap();
      return FALSE;
   }

   /* point past request header for filename,
    * and copy filename into request
    */
   cp = (char*)ptreq + sizeof(ptreq->tf_op);
   strcpy(cp, fname);

   /* point past filename, and copy mode into request */
   cp += strlen(fname) + 1;
   if(cn->tf_mode == OCTET)
      strcpy(cp, "octet");
   else if(cn->tf_mode == ASCII)
      strcpy(cp, "netascii");

   err = tf_write(cn, reqlen);
   if(err == 0)
      cn->tf_state = ACKWAIT;
   else
   {
      dtrap();   /* Initial request failed? */
      tfkill(cn);
   }
   return err;
}


#endif   /* TFTP_CLIENT */

