/*
 * FILENAME: nextcarg.c
 *
 * Copyright 1997- 2006 By InterNiche Technologies Inc. All rights reserved
 *
 * Portions Copyright 1986 by Carnegie Mellon
 * Portions Copyright 1984 by the Massachusetts Institute of Technology
 *
 * Copyright (c) 1982, 1986, 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation and other 
 * materials related to such distribution and use acknowledge that 
 * the software was developed by the University of California, Berkeley.
 * The name of the University may not be used to endorse or promote 
 * products derived from this software without specific prior written 
 * permission. THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *
 * Rights, responsibilities and use of this software are controlled by
 * the agreement found in the "LICENSE.H" file distributed with this
 * source code.  "LICENSE.H" may not be removed from this distribution,
 * modified, enhanced nor references to it omitted.
 *
 *
 * MODULE: MISCLIB
 *
 * ROUTINES: nextcarg(),
 *
 * PORTABLE: yes
 */

#include "license.h"
#include "ipport.h"
#include "in_utils.h"



/* FUNCTION: nextcarg()
 *
 * nextcarg() - return next arg from comma delimited arg list passed. 
 * Current (passed) arg is NULL terminated. If the arg points to a 
 * string enclosed in quotes, the following happens. 1. say 
 * arg="string in quotes", other_arg 2. Move the string so that first 
 * quote is overwritten. arg=string in quotes", other_arg 3. Put a 
 * NULL instead of the last quote. That is , arg=string in quotes 4. 
 * nextarg=other_arg The above logic will allow the caller to use 
 * nextcarg() seamlessly, irrespective of whether the input string is 
 * enclosed in quotes or not. Returns pointer to next arg, or NULL if 
 * no more args. 
 *
 * 
 * PARAM1: char * arg
 *
 * RETURNS: 
 */

char *   
nextcarg(char * arg)
{
   char *   cp;

   cp = strchr(arg, ',');

   /* NULL terminate passed arg weather cp is set or not: */
   if ( *arg == '\"' )
   {
      unsigned len = cp-arg-1 ;
      MEMMOVE(arg,arg+1,len);  /* Move the string so that
                                  the first quote is overwritten */
      while (*arg != '\"' )
         arg++;
   }
   else
   {
      while (*arg != ',' && *arg > ' ')
         arg++;
   }
   *arg = 0;

   if (!cp) /* no next arg; return NULL */
      return NULL;

   cp++;       /* move cp past comma */
   while (*cp <= ' ') cp++;
      return cp;
}




