/*
 * File:	mcf5223.h
 * Purpose:	Register and bit definitions for the MCF5223
 *
 * Notes:	
 *	
 */

#ifndef __MCF5223_H__
#define __MCF5223_H__

/********************************************************************/
/*
 * 5223 includes
 */

#include "mcf5223_scm.h"
#include "mcf5223_pmm.h"
#include "mcf5223_dma.h"
#include "mcf5223_uart.h"
#include "mcf5223_i2c.h"
#include "mcf5223_qspi.h"
#include "mcf5223_rtc.h"
#include "mcf5223_dtim.h"
#include "mcf5223_intc.h"
#include "mcf5223_intc_iack.h"
#include "mcf5223_fec.h"
#include "mcf5223_gpio.h"
#include "mcf5223_cim.h"
#include "mcf5223_clock.h"
#include "mcf5223_eport.h"
#include "mcf5223_pit.h"
#include "mcf5223_adc.h"
#include "mcf5223_pwm.h"
#include "mcf5223_can.h"
#include "mcf5223_cfm.h"
#include "mcf5223_rng.h"
#include "mcf5223_phy.h"
#include "mii.h"

/********************************************************************/
/*
 * function prototypes
 */

void 
PIT_Timer_Init(uint8 PCSR, uint16 PMR);

void 
cpu_pause(int usecs);



#endif /* __MCF5223_H__ */
