/*
 * File:		m5223evb.h
 * Purpose:		Evaluation board definitions and memory map information
 *
 * Notes:
 */

#ifndef _M5223EVB_H
#define _M5223EVB_H

/********************************************************************/

#include "mcf5xxx.h"
#include "io.h"

/********************************************************************/

/*
 * Debug prints ON (#undef) or OFF (#define)
 */
#undef DEBUG

/* 
 * System Bus Clock Info 
 */
#define REF_CLK_MHZ         	(16)
#define REF_CLK_KHZ         	(16000)
#define	SYS_CLK_MHZ		60	/* system bus frequency in MHz */
#define SYS_CLK_KHZ		60000	/* system bus frequency in kHz */
#define SYSTEM_PERIOD		12	/* system clock period in ns. */
extern int sys_clk_khz;
extern int sys_clk_mhz;
/* 
 * System Bus Clock Info 
 */
#define	SYSTEM_CLOCK			60		/* system bus frequency in MHz */
#define PERIOD					20	/* system bus period in ns */
#define UART_BAUD				115200	/*  19200*/
#define TERMINAL_PORT			0

/*
 * LED Info
 */
//#undef HAS_LEDS
#define HAS_LEDS 1

/*
 * Ethernet Port Info
 */
#define FEC_PHY0            (0x00)

/* 
 * Memory map definitions from linker command files 
 */
extern uint8 __IPSBAR[];
extern uint8 __SRAM[];
extern uint8 __SRAM_SIZE[];

/* 
 * Memory Map Info 
 */
#define IPSBAR_ADDRESS			(uint32)__IPSBAR

#define SRAM_ADDRESS			(uint32)__SRAM
#define SRAM_SIZE				(uint32)__SRAM_SIZE

/*
 *	Interrupt Controller Definitions
 */
#define TIMER_NETWORK_LEVEL		3
#define FEC_LEVEL				4

/*
 *	Timer period info
 */
#define TIMER_NETWORK_PERIOD	1000000000/0x10000	/* 1 sec / max timeout */

/********************************************************************/
/********************************************************************/
/********************************************************************/
#ifdef HAS_LEDS /* { */

	#define LED0_TOGGLE     MCF_GPIO_PORTTC = (uint8)(MCF_GPIO_PORTTC ^ MCF_GPIO_PORTTC_PORTTC0)
	#define LED1_TOGGLE     MCF_GPIO_PORTTC = (uint8)(MCF_GPIO_PORTTC ^ MCF_GPIO_PORTTC_PORTTC1);
	#define LED2_TOGGLE     MCF_GPIO_PORTTC = (uint8)(MCF_GPIO_PORTTC ^ MCF_GPIO_PORTTC_PORTTC2);
	#define LED3_TOGGLE     MCF_GPIO_PORTTC = (uint8)(MCF_GPIO_PORTTC ^ MCF_GPIO_PORTTC_PORTTC3);

	#define LED0_ON     	MCF_GPIO_PORTTC = (uint8)(MCF_GPIO_PORTTC | MCF_GPIO_PORTTC_PORTTC0)
	#define LED1_ON		    MCF_GPIO_PORTTC = (uint8)(MCF_GPIO_PORTTC | MCF_GPIO_PORTTC_PORTTC1);
	#define LED2_ON         MCF_GPIO_PORTTC = (uint8)(MCF_GPIO_PORTTC | MCF_GPIO_PORTTC_PORTTC2);
	#define LED3_ON         MCF_GPIO_PORTTC = (uint8)(MCF_GPIO_PORTTC | MCF_GPIO_PORTTC_PORTTC3);

	#define LED0_OFF        MCF_GPIO_PORTTC = (uint8)(MCF_GPIO_PORTTC & ~MCF_GPIO_PORTTC_PORTTC0)
	#define LED1_OFF        MCF_GPIO_PORTTC = (uint8)(MCF_GPIO_PORTTC & ~MCF_GPIO_PORTTC_PORTTC1);
	#define LED2_OFF        MCF_GPIO_PORTTC = (uint8)(MCF_GPIO_PORTTC & ~MCF_GPIO_PORTTC_PORTTC2);
	#define LED3_OFF        MCF_GPIO_PORTTC = (uint8)(MCF_GPIO_PORTTC & ~MCF_GPIO_PORTTC_PORTTC3);

	#define LED_INIT()		Leds_Init()
#else  /* No LEDS  */
	#define LED_INIT()		void()
#endif
	#define RXLED_TOGGLE     MCF_GPIO_PORTLD = (uint8)(MCF_GPIO_PORTLD ^ MCF_GPIO_PORTLD_PORTLD5);
	#define TXLED_TOGGLE     MCF_GPIO_PORTLD = (uint8)(MCF_GPIO_PORTLD ^ MCF_GPIO_PORTLD_PORTLD6);
	#define ACTLED_TOGGLE    MCF_GPIO_PORTLD = (uint8)(MCF_GPIO_PORTLD ^ MCF_GPIO_PORTLD_PORTLD0);
/********************************************************************/
/********************************************************************/
void Leds_Init();
void board_led_display(uint8 number);
/********************************************************************/
/********************************************************************/
#endif /* _M5223EVB_H */
