/*
 * File:		mcf5223evb.c
 * Purpose:		Source to EVB specific routines
 *
 * Notes:
 */
/********************************************************************/
#include "common.h"


/********************************************************************/
/*
 * Setup LED on the EVB
 */
void
Leds_Init(void){
//user LEDs
    /* Enable signals as GPIO */
    MCF_GPIO_PTCPAR = 0
        | MCF_GPIO_PTCPAR_TIN3_GPIO
        | MCF_GPIO_PTCPAR_TIN2_GPIO
        | MCF_GPIO_PTCPAR_TIN1_GPIO
        | MCF_GPIO_PTCPAR_TIN0_GPIO;
    
    /* Enable signals as digital outputs */
    MCF_GPIO_DDRTC = 0
        | MCF_GPIO_DDRTC_DDRTC3
        | MCF_GPIO_DDRTC_DDRTC2
        | MCF_GPIO_DDRTC_DDRTC1
        | MCF_GPIO_DDRTC_DDRTC0;

	MCF_GPIO_PORTTC = 0x00; // TURN LEDS OFF

}

/********************************************************************/
/* 
 * Display the lower 4 bits of 'number' on the 4 LEDs connected to 
 * TIN[3:0]
 *
 *  LED: LED4 LED3 LED2 LED1
 *  PIN: TIN3 TIN2 TIN1 TIN0
 *  BIT:    3    2    1    0
 */
void
board_led_display(uint8 number)
{
    /* Set output values */
    MCF_GPIO_PORTTC = number;
}
/********************************************************************/


/********************************************************************/
// EMG - Poll switch status
/********************************************************************/
int poll_switches( void )
{
	int		map;

	map = 0;

    /* SW3 */
	if (!(MCF_GPIO_SETNQ & MCF_GPIO_SETNQ_SETNQ1))
    	map |= 0x04;
    
    /* SW1 */
	if (!(MCF_GPIO_SETNQ & MCF_GPIO_SETNQ_SETNQ4))
    	map |= 0x01;
    
    /* Abort */
	if (!(MCF_GPIO_SETNQ & MCF_GPIO_SETNQ_SETNQ7))
    	map |= 0x08;
    
    /* SW2 */
	if (!(MCF_GPIO_SETGP & MCF_GPIO_SETGP_SETGP3))
    	map |= 0x02;
    
    return( map );
}
/********************************************************************/


/*********************************************************************
* init_adc - Analog-to-Digital Converter (ADC)                       *
**********************************************************************/
void init_adc (void)
{
    // Scan mode = Loop parallel, converters A and B run simultaneously
    // ADC clock frequency = 10.67 MHz
    // Voltage reference supplied by VDDA and VSSA
    // All ADC interrupts disabled
    //  
    // Sample list for converter A:
    //     Sample 0 : ANA0
    //                Low limit = $000, High limit = $FFF, Offset = $000
    //     Sample 1 : ANA1
    //                Low limit = $000, High limit = $FFF, Offset = $000
    //     Sample 2 : ANA2
    //                Low limit = $000, High limit = $FFF, Offset = $000
    //     Sample 3 : ANA3
    //                Low limit = $000, High limit = $FFF, Offset = $000
    //  
    // Sample list for converter B:
    //     Sample 4 : ANB0
    //                Low limit = $000, High limit = $FFF, Offset = $000
    //     Sample 5 : ANB1
    //                Low limit = $000, High limit = $FFF, Offset = $000
    //     Sample 6 : ANB2
    //                Low limit = $000, High limit = $FFF, Offset = $000
    //     Sample 7 : ANB3
    //                Low limit = $000, High limit = $FFF, Offset = $000


    // Initialise ADC

    //     CLST1[SAMPLE3]  = %011
    //     CLST1[SAMPLE2]  = %010
    //     CLST1[SAMPLE1]  = %001
    //     CLST1[SAMPLE0]  = 0 
    MCF_ADC_ADLST1 = MCF_ADC_ADLST1_SAMPLE3(0x3) |
                MCF_ADC_ADLST1_SAMPLE2(0x2) |
                MCF_ADC_ADLST1_SAMPLE1(0x1);

    //     CLST2[SAMPLE7]  = %111
    //     CLST2[SAMPLE6]  = %110
    //     CLST2[SAMPLE5]  = %101
    //     CLST2[SAMPLE4]  = %100
    MCF_ADC_ADLST2 = MCF_ADC_ADLST2_SAMPLE7(0x7) |
                MCF_ADC_ADLST2_SAMPLE6(0x6) |
                MCF_ADC_ADLST2_SAMPLE5(0x5) |
                MCF_ADC_ADLST2_SAMPLE4(0x4);

    //     CTRL2[STOP1]    = 1 
    //     CTRL2[START1]   = 0 
    //     CTRL2[SYNC1]    = 0 
    //     CTRL2[EOSIE1]   = 0 
    //     CTRL2[SIMULT]   = 1 
    //     CTRL2[DIV]      = $2
    MCF_ADC_CTRL2 = MCF_ADC_CTRL2_DIV(5);

    // Power up ADC converter(s) in use

    //     PWR[ASB]        = 0 
    //     PWR[PUDELAY]    = $d
    //     PWR[APD]        = 0 
    //     PWR[PD2]        = 1 
    //     PWR[PD1]        = 0 
    //     PWR[PD0]        = 0 
    MCF_ADC_POWER = MCF_ADC_POWER_PUDELAY(4);

    //     CTRL1[STOP0]    = 1 
    //     CTRL1[START0]   = 0 
    //     CTRL1[SYNC0]    = 0 
    //     CTRL1[EOSIE0]   = 0 
    //     CTRL1[ZCIE]     = 0 
    //     CTRL1[LLMTIE]   = 0 
    //     CTRL1[HLMTIE]   = 0 
    //     CTRL1[CHNCFG3]  = 0 
    //     CTRL1[CHNCFG2]  = 0 
    //     CTRL1[CHNCFG1]  = 0 
    //     CTRL1[CHNCFG0]  = 0 
    //     CTRL1[SMODE]    = %010
    MCF_ADC_CTRL1 = MCF_ADC_CTRL1_SMODE(2);

    /* Pin assignments for port AN 
           Pin AN7 : Analog input AN7 
           Pin AN6 : Analog input AN6 
           Pin AN5 : Analog input AN5 
           Pin AN4 : Analog input AN4 
           Pin AN3 : Analog input AN3 
           Pin AN2 : Analog input AN2 
           Pin AN1 : Analog input AN1 
           Pin AN0 : Analog input AN0 
    */
    MCF_GPIO_DDRAN = 0;
    MCF_GPIO_PANPAR = MCF_GPIO_PANPAR_PANPAR7 |
                      MCF_GPIO_PANPAR_PANPAR6 |
                      MCF_GPIO_PANPAR_PANPAR5 |
                      MCF_GPIO_PANPAR_PANPAR4 |
                      MCF_GPIO_PANPAR_PANPAR3 |
                      MCF_GPIO_PANPAR_PANPAR2 |
                      MCF_GPIO_PANPAR_PANPAR1 |
                      MCF_GPIO_PANPAR_PANPAR0;    
}


void start_AD( void )
{
	/* Clear stop bits */
	MCF_ADC_CTRL1 &= ~MCF_ADC_CTRL1_STOP0; 			
	MCF_ADC_CTRL2 &= ~MCF_ADC_CTRL2_STOP1; 			

	/* Set start bit */
	MCF_ADC_CTRL1 |= MCF_ADC_CTRL1_START0; 			
}


short read_AD( int channel )
{
	switch( channel )
	{
		case 0:
			return( ((MCF_ADC_ADRSLT0&0x7FF8)>>3) );
			
		case 1:
			return( ((MCF_ADC_ADRSLT1&0x7FF8)>>3) );

		case 2:
			return( ((MCF_ADC_ADRSLT2&0x7FF8)>>3) );

		case 3:
			return( ((MCF_ADC_ADRSLT3&0x7FF8)>>3) );

		case 4:
			return( ((MCF_ADC_ADRSLT4&0x7FF8)>>3) );

		case 5:
			return( ((MCF_ADC_ADRSLT5&0x7FF8)>>3) );

		case 6:
			return( ((MCF_ADC_ADRSLT6&0x7FF8)>>3) );

		case 7:
			return( ((MCF_ADC_ADRSLT7&0x7FF8)>>3) );			
	}
	
	return(0);
}