/*
 * File:    mcf5223_rng.h
 * Purpose: Register and bit definitions
 */

#ifndef __MCF5223_RNG_H__
#define __MCF5223_RNG_H__

/*********************************************************************
*
* Random Number Generator (RNG)
*
*********************************************************************/

/* Register read/write macros */
#define MCF_RNG_RNGCR             (*(vuint32*)(&__IPSBAR[0x1F0000]))
#define MCF_RNG_RNGSR             (*(vuint32*)(&__IPSBAR[0x1F0004]))
#define MCF_RNG_RNGER             (*(vuint32*)(&__IPSBAR[0x1F0008]))
#define MCF_RNG_RNGOUT            (*(vuint32*)(&__IPSBAR[0x1F000C]))

/* Bit definitions and macros for MCF_RNG_RNGCR */
#define MCF_RNG_RNGCR_GO          (0x00000001)
#define MCF_RNG_RNGCR_HA          (0x00000002)
#define MCF_RNG_RNGCR_IM          (0x00000004)
#define MCF_RNG_RNGCR_CI          (0x00000008)

/* Bit definitions and macros for MCF_RNG_RNGSR */
#define MCF_RNG_RNGSR_SV          (0x00000001)
#define MCF_RNG_RNGSR_LRS         (0x00000002)
#define MCF_RNG_RNGSR_FUF         (0x00000004)
#define MCF_RNG_RNGSR_EI          (0x00000008)
#define MCF_RNG_RNGSR_OFL(x)      (((x)&0x000000FF)<<8)
#define MCF_RNG_RNGSR_OFS(x)      (((x)&0x000000FF)<<16)

/* Bit definitions and macros for MCF_RNG_RNGER */
#define MCF_RNG_RNGER_ENTROPY(x)  (((x)&0xFFFFFFFF)<<0)

/* Bit definitions and macros for MCF_RNG_RNGOUT */
#define MCF_RNG_RNGOUT_OUTPUT(x)  (((x)&0xFFFFFFFF)<<0)

/********************************************************************/

#endif /* __MCF5223_RNG_H__ */
