
/*********************************************************************
 *
 * Copyright:
 *	2005 FREESCALE, INC. All Rights Reserved.  
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Motorola, Inc. This 
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, FREESCALE 
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
 *  ACCOMPANYING WRITTEN MATERIALS.
 * 
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL FREESCALE BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
 * 
 *  Freescale assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/

/*
 * File:		io.c
 * Purpose:		Serial Input/Output routines
 *
 */

#include "common.h"
#include "uart.h"

/********************************************************************/
char
in_char (void)
{
   return uart_getc(0);
}
/********************************************************************/
void
out_char (char ch)
{
   unsigned char c = (unsigned char)ch;
   
   if (c == '\n')
      uart_putc(0, '\r');
   uart_putc(0, c);

#if 0
   /* flush the ouput buffer if c == \n */
   if (c == '\n')
   {
      while (!uart_flush(0)) 
      {
         /* null */ ;
      }
   }
#endif

}
/********************************************************************/
int
char_present (void)
{
   return uart_present(0);
}
/********************************************************************/
