/******************************************************************************\
*  
*  TECHNICKA UNIVERZITA V KOSICIACH
*  FAKULTA ELEKTROTECHNIKY A INFORMATIKY
*  KATEDRA ELEKTRONIKY A MULTIMEDIALNYCH TELEKOMUNIKACII
*  
*  MIKROPROCESOROVA TECHNIKA
*  (material pre vyuku predmetu)
*
*  Subor:   main.c
*  Verzia:  v1.00
*  Popis:   Meranie zrychlenia v osiach X,Y a Z s vystupom na seriovu linku  
*           vo forme bargrafu
*  MCU:     Freescale Coldfire MCF52233
*  HW:      M552233DEMO (Freescale & P&E-MICRO & Axiom Manufacturing)
*  Autor:   Michal Varchola
*  Revizia: 2007-11-18
*  Zmeny:   2007-11-18 (MV) -> vytvorenie suboru 
*
\******************************************************************************/

/* hlavickovy subor support_common.h obsahuje (okrem ineho):
   -> Deklaracie I/O registrov
   -> Definicie systemovych nastaveni (Frekvencia systemovej zbernice, 
                                       Baudrate UARTu)
   -> Deklaracie funkcii potrebnych pre inicialiaciu procesoru, PLL, UARTu... */
#include "support_common.h"

#define VREF 3000       // napatova referencia = 3000mV
#define DELAY 25000     // cakanie medzi meraniami = 25000us

// redeklaracie I/O registrov
#define DDR_ACC         MCF_GPIO_DDRTA
#define PORT_ACC        MCF_GPIO_PORTTA
// redeklaracie pinov
#define ACC_SEL0        MCF_GPIO_PORTTA_PORTTA0
#define ACC_SEL1        MCF_GPIO_PORTTA_PORTTA1
#define ACC_SLEEP       MCF_GPIO_PORTTA_PORTTA2
// spolocne ovladanie pinov nastavujucich citlivost akcelometra 
#define ACC_SENSIT(a)   (a & (ACC_SEL0|ACC_SEL1))
  #define SENSIT_1_5G   0
  #define SENSIT_2G     1
  #define SENSIT_4G     2
  #define SENSIT_6G     3   

/******************************************************************************\
*
* Funkcia:   init_adc
* Popis:     inicializacia AD prevodniku
* Vstup:     void
* Vystup:    void
* HW Naroky: ADC
*
\******************************************************************************/
void init_adc (void)
{
  // nastavenie LOLIM (Low Limit), HILIM(High Limit) a OFFST (Offset) 
  MCF_ADC_ADLLMT4 = 0;
  MCF_ADC_ADHLMT4 = MCF_ADC_ADHLMT_HLMT(0xfff);
  MCF_ADC_ADOFS4 = 0;
  
  MCF_ADC_ADLLMT5 = 0;
  MCF_ADC_ADHLMT5 = MCF_ADC_ADHLMT_HLMT(0xfff);
  MCF_ADC_ADOFS5 = 0;
    
  MCF_ADC_ADLLMT6 = 0;
  MCF_ADC_ADHLMT6 = MCF_ADC_ADHLMT_HLMT(0xfff);
  MCF_ADC_ADOFS6 = 0;

  // inicializacia ADC */
  MCF_ADC_ADZCC = 0;
  MCF_ADC_ADLST1 = MCF_ADC_ADLST1_SAMPLE3(0x3) |  
                   MCF_ADC_ADLST1_SAMPLE2(0x2) | 
                   MCF_ADC_ADLST1_SAMPLE1(0x1);
  MCF_ADC_ADLST2 = MCF_ADC_ADLST2_SAMPLE7(0x7) |
                   MCF_ADC_ADLST2_SAMPLE6(0x6) |
                   MCF_ADC_ADLST2_SAMPLE5(0x5) |
                   MCF_ADC_ADLST2_SAMPLE4(0x4);
  MCF_ADC_ADSDIS = MCF_ADC_ADSDIS_DS7 |
                 //MCF_ADC_ADSDIS_DS6 |
                 //MCF_ADC_ADSDIS_DS5 |
                 //MCF_ADC_ADSDIS_DS4 |
                   MCF_ADC_ADSDIS_DS3 |
                   MCF_ADC_ADSDIS_DS2 |                     
                   MCF_ADC_ADSDIS_DS1 |
                   MCF_ADC_ADSDIS_DS0 ;
  MCF_ADC_CAL = 0;
    
  // Zapnutie prevodnika
  MCF_ADC_POWER = MCF_ADC_POWER_PUDELAY(0xd) |
                  MCF_ADC_POWER_PD2          |
                  MCF_ADC_POWER_PD0;
  // Cakanie kym bude AD prevodnik B celkom zapnutny
  while (MCF_ADC_POWER & MCF_ADC_POWER_PSTS1) {}
    
  MCF_ADC_CTRL1 = MCF_ADC_CTRL1_STOP0 |     // sekvencny rezim  
                  MCF_ADC_CTRL1_SMODE(0x3); // snimania pre ADCB
  MCF_ADC_CTRL2 = MCF_ADC_CTRL2_START1 |      // start merania
                  MCF_ADC_CTRL2_DIV(4);
                    
  MCF_GPIO_PANPAR = MCF_GPIO_PORTAN_PORTAN4 |
                    MCF_GPIO_PORTAN_PORTAN5 | // nastavenie pinov
                    MCF_GPIO_PORTAN_PORTAN6 ; // ako AIN4,AIN5,AIN6
}

/******************************************************************************\
*
* Funkcia:   cpu_pause
* Popis:     Funkcia vytvori pauzu na zadany pocet mikrosekund
* Vstup:     int usecs: doba pauzy v mikrosekundach
* Vystup:    void
* HW Naroky: DTIM3 (DMA Timer 3)
*
\******************************************************************************/
void cpu_pause(int usecs){
  // Inicializacia DMA Timer 3 
  // MCF_DTIM3_DTRR = DMA Timer Reference Register
  MCF_DTIM3_DTRR = (vuint32)(usecs-1); /* refernecna hodnota pre porovnavannie; 
                                          bude porovnavana s aktualnym stavom 
                                          DTIM3                               */
  // MCF_DTIM3_DTER = DMA Timer Event Registers
  MCF_DTIM3_DTER = MCF_DTIM_DTER_REF;  /* citlivost na udalost zhody referencnej 
                                          a napocitanej hodnoty v DTIM3       */
  // MCF_DTIM3_DTMR = DMA Timer Mode Registers
  MCF_DTIM3_DTMR = 0
    | MCF_DTIM_DTMR_PS(SYSTEM_CLOCK)   // nastavenie preddelicky:podla parametru
    | MCF_DTIM_DTMR_ORRI               /* povolenie prerusenia pre udalost zhody 
                                          ref. a napocitanej hodnoty v DTIM3  */
    | MCF_DTIM_DTMR_FRR                /* reset casovaca akonahle dosiahne 
                                          referencnu uroven */
    | MCF_DTIM_DTMR_CLK_DIV1           // vstupne hodiny DTIM3 = SYSTEM_CLOCK/1
    | MCF_DTIM_DTMR_RST;               // povolenie casovaca    
  
  //pokial nebude dosiahnuta referencna hodnota v DTIM3...
  while ((MCF_DTIM3_DTER & MCF_DTIM_DTER_REF) == 0) 
  {};                                  //...nerob nic a cakaj
  
  //vypnutie DMA Timer 3  
  MCF_DTIM3_DTMR = 0;
}

/******************************************************************************\
*
* Funkcia:   bargraph
* Popis:     Zobrazi na standardnom vystupe "bargraf" v rozsahu <-15,+15>
*            Symbol zobrazujuci nulu je odovzdany ako parameter funkcie
*            
* Vstup:     int value: hodnota bargrafu v rozsahu <-15,+15>
*            char zero: znak zobrazovany ako nula (stred) bargrafu
* Vystup:    void
* Priklad:   value = 10, zero = X:               X==========
*            value = -3, zero = Y:            ===Y
*            value =  0, zero = Z:               Z
*
\******************************************************************************/
void bargraph(int value, char zero){
  char bar[32];             // pole bargrafu
  char i;
  for (i=0;i<32;i++)        // vymazanie bargrafu
    bar[i]=' ';
  bar[15] = zero;           // uprostred zobrazit nulu 
  if (value >= 15)          // ochrana proti preteceniu
    value =  15;
  if (value <=-15)          // ochrana proti preteceniu
    value = -15;
  if (value > 0)            // pre kladne cisla
    for(i=0;i<value;i++)    // zobraz prislusny pocet bodov
      bar[16+i] = '=';  
  if (value < 0)            // pre kladne cisla
    for(i=0;i>value;i--)    // zobraz prislusny pocet bodov
      bar[14+i] = '=';
  bar[31] = 0;              // vloz ukoncovaci znak na koniec retazca
  printf("%s",bar);         // posli retazec na standardny vystup
}

/******************************************************************************\
*
* Funkcia:   main
* Popis:     Funckia Main, tu sa zacina vykonavanie uzivatelskeho programu
*            bezprostredne po inicializacii procesora a niektorych periferii
*            v ramci startovacieho kodu
* Vstup:     ziaden
* Vystup:    int implicitne 0 (funkcia sa nikdy nekonci, v principe moze byt 
*            navratova hodnota typu void, teda ziadna)
*
\******************************************************************************/
int main(void){ 
  
  init_adc();
  // tieto piny nastavit ako vystupne                
  DDR_ACC  = ACC_SEL0 | ACC_SEL1 | ACC_SLEEP;               
  // vypnut akcelometer z rezimu spanku
  // rozsah merania <-1.5g,1.5g>
  PORT_ACC = ACC_SLEEP | ACC_SENSIT(SENSIT_1_5G);

  while(1){
    bargraph(((MCF_ADC_ADRSLT4-16384)/800)-0,'X'); //vystup pre os X
    bargraph(((MCF_ADC_ADRSLT5-16384)/800)-4,'Y'); //vystup pre os Y
    bargraph(((MCF_ADC_ADRSLT6-16384)/800)-0,'Z'); //vystup pre os Z
    printf("\n");
    cpu_pause(DELAY);                                                               
  }  
  return 0;
}
