/******************************************************************************\
*  
*  TECHNICKA UNIVERZITA V KOSICIACH
*  FAKULTA ELEKTROTECHNIKY A INFORMATIKY
*  KATEDRA ELEKTRONIKY A MULTIMEDIALNYCH TELEKOMUNIKACII
*  
*  MIKROPROCESOROVA TECHNIKA
*  (material pre vyuku predmetu)
*
*  Subor:   main.c
*  Verzia:  v1.00
*  Popis:   Meranie napatia na bezci odporoveho trimra s vystupom cez UART
*  MCU:     Freescale Coldfire MCF52233
*  HW:      M552233DEMO (Freescale & P&E-MICRO & Axiom Manufacturing)
*  Autor:   Michal Varchola
*  Revizia: 2007-11-07
*  Zmeny:   2007-11-07 (MV) -> vytvorenie suboru 
*
\******************************************************************************/


/* hlavickovy subor support_common.h obsahuje (okrem ineho):
   -> Deklaracie I/O registrov
   -> Definicie systemovych nastaveni (Frekvencia systemovej zbernice, 
                                       Baudrate UARTu)
   -> Deklaracie funkcii potrebnych pre inicialiaciu procesoru, PLL, UARTu... */
#include "support_common.h"
#define VREF 3000       // napatova referencia = 3000mV
#define DELAY 100000    // cakanie medzi meraniami = 100,000us = 0.1s

/******************************************************************************\
*
* Funkcia:   init_adc
* Popis:     inicializacia AD prevodniku
* Vstup:     void
* Vystup:    void
* HW Naroky: ADC
*
\******************************************************************************/

void init_adc (void)
{
    /* Scan mode = Loop sequential 
       ADC clock frequency = 5.00 MHz 
       Voltage reference supplied by VDDA and VSSA 
       All ADC interrupts disabled 
       Single-ended inputs
       
       Sample list: 
           Sample 0 : AN0 
                      Low limit = $000, High limit = $FFF, Offset = $000 
           Sample 1 : Disabled
           Sample 2 : Disabled 
           Sample 3 : Disabled 
           Sample 4 : Disabled 
           Sample 5 : Disabled 
           Sample 6 : Disabled 
           Sample 7 : Disabled 
    */

  // nastavenie LOLIM (Low Limit), HILIM(High Limit) a OFFST (Offset) 
    MCF_ADC_ADLLMT0 = 0;
    MCF_ADC_ADHLMT0 = MCF_ADC_ADHLMT_HLMT(0xfff);
    MCF_ADC_ADOFS0 = 0;

  // inicializacia ADC */
    MCF_ADC_ADZCC = 0;
    MCF_ADC_ADLST1 = MCF_ADC_ADLST1_SAMPLE3(0x3) |
                     MCF_ADC_ADLST1_SAMPLE2(0x2) |
                     MCF_ADC_ADLST1_SAMPLE1(0x1);
    MCF_ADC_ADLST2 = MCF_ADC_ADLST2_SAMPLE7(0x7) |
                     MCF_ADC_ADLST2_SAMPLE6(0x6) |
                     MCF_ADC_ADLST2_SAMPLE5(0x5) |
                     MCF_ADC_ADLST2_SAMPLE4(0x4);
    MCF_ADC_ADSDIS = MCF_ADC_ADSDIS_DS7 |
                     MCF_ADC_ADSDIS_DS6 |
                     MCF_ADC_ADSDIS_DS5 |
                     MCF_ADC_ADSDIS_DS4 |
                     MCF_ADC_ADSDIS_DS3 |
                     MCF_ADC_ADSDIS_DS2 |                     
                     MCF_ADC_ADSDIS_DS1;
    MCF_ADC_CAL = 0;
    
    MCF_ADC_CTRL2 = MCF_ADC_CTRL2_STOP1 |
                    MCF_ADC_CTRL2_DIV(0x2);
     // Zapnutie prevodnika
    MCF_ADC_POWER = MCF_ADC_POWER_PUDELAY(0xd) |
                    MCF_ADC_POWER_PD2          |
                    MCF_ADC_POWER_PD1;
     // Cakanie kym bude AD prevodnik A celkom zapnutny
    while (MCF_ADC_POWER & MCF_ADC_POWER_PSTS0) {}
    MCF_GPIO_PANPAR = MCF_GPIO_PORTAN_PORTAN0; //nastavenie pinu ako AIN0
    MCF_ADC_CTRL1 = MCF_ADC_CTRL1_START0 |          
                  MCF_ADC_CTRL1_SMODE(0x2);    // sekvencny rezim snimania 

}

/******************************************************************************\
*
* Funkcia:   cpu_pause
* Popis:     Funkcia vytvori pauzu na zadany pocet mikrosekund
* Vstup:     int usecs: doba pauzy v mikrosekundach
* Vystup:    void
* HW Naroky: DTIM3 (DMA Timer 3)
*
\******************************************************************************/
void cpu_pause(int usecs){
  // Inicializacia DMA Timer 3 
  // MCF_DTIM3_DTRR = DMA Timer Reference Register
  MCF_DTIM3_DTRR = (vuint32)(usecs-1); /* refernecna hodnota pre porovnavannie; 
                                          bude porovnavana s aktualnym stavom 
                                          DTIM3                               */
  // MCF_DTIM3_DTER = DMA Timer Event Registers
  MCF_DTIM3_DTER = MCF_DTIM_DTER_REF;  /* citlivost na udalost zhody referencnej 
                                          a napocitanej hodnoty v DTIM3       */
  // MCF_DTIM3_DTMR = DMA Timer Mode Registers
  MCF_DTIM3_DTMR = 0
    | MCF_DTIM_DTMR_PS(SYSTEM_CLOCK)   // nastavenie preddelicky:podla parametru
    | MCF_DTIM_DTMR_ORRI               /* povolenie prerusenia pre udalost zhody 
                                          ref. a napocitanej hodnoty v DTIM3  */
    | MCF_DTIM_DTMR_FRR                /* reset casovaca akonahle dosiahne 
                                          referencnu uroven */
    | MCF_DTIM_DTMR_CLK_DIV1           // vstupne hodiny DTIM3 = SYSTEM_CLOCK/1
    | MCF_DTIM_DTMR_RST;               // povolenie casovaca    
  
  //pokial nebude dosiahnuta referencna hodnota v DTIM3...
  while ((MCF_DTIM3_DTER & MCF_DTIM_DTER_REF) == 0) 
  {};                                  //...nerob nic a cakaj
  
  //vypnutie DMA Timer 3  
  MCF_DTIM3_DTMR = 0;
}



/******************************************************************************\
*
* Funkcia:   main
* Popis:     Funckia Main, tu sa zacina vykonavanie uzivatelskeho programu
*            bezprostredne po inicializacii procesora a niektorych periferii
*            v ramci startovacieho kodu
* Vstup:     ziaden
* Vystup:    int implicitne 0 (funkcia sa nikdy nekonci, v principe moze byt 
*            navratova hodnota typu void, teda ziadna)
*
\******************************************************************************/

int main(void)
{
  int adc_reg;
  int adc_voltage;
  
  init_adc();

  while(1)                                      
  {
    adc_reg = MCF_ADC_ADRSLT0;                  // nacitanie hodnoty z registra 
    adc_voltage = (VREF * adc_reg)/32767;       // prepocet na napatie  
    // vypis na standardny vystup (UART)
    printf("reg = %5.1d;  voltage = %4.1d mV \n",adc_reg,adc_voltage);
    cpu_pause(DELAY);                                                           
  }
  return 0;
}
