/******************************************************************************\
*  
*  TECHNICKA UNIVERZITA V KOSICIACH
*  FAKULTA ELEKTROTECHNIKY A INFORMATIKY
*  KATEDRA ELEKTRONIKY A MULTIMEDIALNYCH TELEKOMUNIKACII
*  
*  MIKROPROCESOROVA TECHNIKA
*  (material pre vyuku predmetu)
*
*  Subor:   main.c
*  Verzia:  v1.00
*  Popis:   Ovladanie LED tlacidlami (demonstracia pouzitia GPIO pre ovladanie  
*           LED a nacitavania stavu tlacidiel)
*  Detaily: Program vykonava posun svietiaceho bodu na LED do prava 
*           stlacenim SW2 alebo dolava stlacenim SW1
*  MCU:     Freescale Coldfire MCF52233
*  HW:      M552233DEMO (Freescale & P&E-MICRO & Axiom Manufacturing)
*  Autor:   Michal Varchola
*  Revizia: 2007-11-07
*  Zmeny:   2007-11-07 (MV) -> vytvorenie suboru 
*
\******************************************************************************/

/*
SKRATKY:
  PLL  -> Phase Locked Loop
  UART -> Universal Asynchronous Receiver/Transmitter
  LED  -> Light Emitting Diode
  DDR  -> Data Direction Register
  GPIO -> General Purpose Inputs/Outputs
  TC   -> Timer/Counter
  MCF  -> prefix oznacenia procesoru
  PWM  -> Pulse Width Modulation
  MCU  -> MicroController Unit
  SWCH -> Switcher
*/


/* hlavickovy subor support_common.h obsahuje (okrem ineho):
   -> Deklaracie I/O registrov
   -> Definicie systemovych nastaveni (Frekvencia systemovej zbernice, 
                                       Baudrate UARTu)
   -> Deklaracie funkcii potrebnych pre inicialiaciu procesoru, PLL, UARTu... */
#include "support_common.h" /* include peripheral declarations and more */

/* nasleduje:
   -> re-deklaracie pouzivanych I/O registrov pre lepsiu zrozumitelnost kodu
   -> definicie konstant pre zvysenu "cistotu" a pohodlnu editaciu kodu    */
/* MCF_GPIO_PORTTC je deklaracia registra v I/O prestore,urceneho pre fyzicky 
   vystup dat,PORT je oznaceny TC pretoze alternativna funkcia I/O pinov spociva
   v spolupraci s Citacom/Casovacom (TC=Timer,Counter). Tieto piny je mozne
   pouzit (okrem rozsvecovania LED) ako vstup hodinovych impulzov pre TC, ako
   vystup PWM modulacie...(niektore MCU maju tieto porty cislovane, napr x51) */
#define LED_PORT    MCF_GPIO_PORTTC         // port, kde su pripojene LED
/* MCF_GPIO_DDRTC je deklaracia registra v I/O prestore, ktory urcuje smer  
   vystupnych dat; ak bit = 0 -> prislusny pin je nastaveny ako vstup; 
                   ak bit = 1 -> prislusny pin je nastaveny ako vystup   */
#define LED_DDR     MCF_GPIO_DDRTC          // smer portu pre LED (vstup/vystup)
// naseduju masky pre prislusne bity/piny napr pre LED2 = 0b00000010 = 0x02
#define LED1        MCF_GPIO_PORTTC_PORTTC0 // maska pre LED1 (LED1=0x01) bit 0
#define LED2        MCF_GPIO_PORTTC_PORTTC1 // maska pre LED2 (LED2=0x02) bit 1
#define LED3        MCF_GPIO_PORTTC_PORTTC2 // maska pre LED3 (LED3=0x04) bit 2
#define LED4        MCF_GPIO_PORTTC_PORTTC3 // maska pre LED4 (LED3=0x08) bit 3

/* MCF_GPIO_SETNQ je reqister s dvojitou funkciou:
        -> zapisom '1' sa nastavi prislusny bit v MCF_GPIO_PORTxx na '1' 
        -> zapisom '0' sa neudeje nic 
        -> citanim tohto registra sa nacita aktualny stav pinov xx portu*/
#define SWCH_PIN    MCF_GPIO_SETNQ          // PINy kde su pripojene tlacidla
#define SWCH_DDR    MCF_GPIO_DDRNQ          // smer portu pre tlacidla
#define SW1         MCF_GPIO_PORTNQ_PORTNQ4 // maska pre SW1 (SW1=0x10) bit 4
#define SW2         MCF_GPIO_PORTNQ_PORTNQ7 // maska pre SW1 (SW1=0x80) bit 7


/******************************************************************************\
*
* Funkcia:   main
* Popis:     Funckia Main, tu sa zacina vykonavanie uzivatelskeho programu
*            bezprostredne po inicializacii procesora a niektorych periferii
*            v ramci startovacieho kodu
* Vstup:     ziaden
* Vystup:    int implicitne 0 (funkcia sa nikdy nekonci, v principe moze byt 
*            navratova hodnota typu void, teda ziadna)
*
\******************************************************************************/
int main(void)
{
  unsigned char swch_state;
  
  //inicializacia GPIO registrov pre ovladanie LED 
  LED_PORT = 0x01;                        // vsetky LED vypnut
  LED_DDR  = (LED1 | LED2 | LED3 | LED4); // piny pre LED -> vystupne
  MCF_GPIO_PTCPAR = 0x00;                 // nastavit multiplexer pinov na GPIO
                                          // piny mozu sluzit alternat.funkciam
  //inicializacia GPIO registrov pre nacitavanie tlacidiel                                        
  SWCH_DDR   = 0x00;                      // piny pre tlacidla -> vstupne
  MCF_GPIO_PNQPAR = 0x00;                 // nastavit multiplexer  pinov na GPIO
                                          // piny mozu sluzit alternat.funkciam
  
  //nekonecna slucka bezne pouzivana pre "embedded" programy                                            
  while(1) {    
    // ak bol zmeneny stav tlacidla SW1
    if ( (SWCH_PIN & SW1) != (swch_state & SW1) ){ 
    swch_state = SWCH_PIN;                // nacitaj do buffru novy stav
      if (!(SWCH_PIN & SW1))              // ak zmena = stlacenie tlacidla
        if (LED_PORT > LED1) LED_PORT >>= 1; // posun bod na LED do lava        
    }
    // ak bol zmeneny stav tlacidla SW2
    if ( (SWCH_PIN & SW2) != (swch_state & SW2) ){
      swch_state = SWCH_PIN;              // nacitaj do buffru novy stav        
      if (!(SWCH_PIN & SW2))              // ak zmena = stlacenie tlacidla
        if (LED_PORT < LED4) LED_PORT <<= 1; // posun bod na LED do prava       
    }       
  }
  return 0; /* sem sa funckia main nikdy nedostane, no pretoze main ma navrtovu
               hodnotu definovanu ako int, je vhodne pre poriadok kodu a "koser"
               C - programovanie doplnit navrat, pretoze ho kompilator moze
               ocakavat.   */
}
