/******************************************************************************\
*  
*  TECHNICKA UNIVERZITA V KOSICIACH
*  FAKULTA ELEKTROTECHNIKY A INFORMATIKY
*  KATEDRA ELEKTRONIKY A MULTIMEDIALNYCH TELEKOMUNIKACII
*  
*  MIKROPROCESOROVA TECHNIKA
*  (material pre vyuku predmetu)
*
*  Subor:   main.c
*  Verzia:  v1.00
*  Popis:   KITT blikac (demonstracia pouzitia GPIO pre ovladanie LED 
*           a Casovaca pre vytvorenie casoveho intervalu blikania)
*  Detaily: Program vykonava posun svietiaceho bodu od LED1 k LED4 a naspet
*  MCU:	    Freescale Coldfire MCF52233
*  HW:      M552233DEMO (Freescale & P&E-MICRO & Axiom Manufacturing)
*  Autor:   Michal Varchola
*  Revizia: 2007-11-07
*  Zmeny:   2007-11-06 (MV) -> vytvorenie suboru 
*
\******************************************************************************/

/*
SKRATKY:
  PLL  -> Phase Locked Loop
  UART -> Universal Asynchronous Receiver/Transmitter
  LED  -> Light Emitting Diode
  DDR  -> Data Direction Register
  GPIO -> General Purpose Inputs/Outputs
  TC   -> Timer/Counter
  MCF  -> prefix oznacenia procesoru
  PWM  -> Pulse Width Modulation
  MCU  -> MicroController Unit
*/

/*
SEKVENCIA ROZSVECOVANIA LED:
------------------------------------------------
hodnota v PORTTC	LED4	LED3	LED2	LED1
binar.		hex.
------------------------------------------------
0b00000001	0x01	vyp		vyp		vyp		zap
0b00000010	0x02	vyp		vyp		zap		vyp
0b00000100	0x04   	vyp		zap		vyp		vyp
0b00001000	0x08	zap		vyp		vyp		vyp	
0b00000100	0x04	vyp		zap		vyp		vyp
0b00000010	0x02	vyp		vyp		zap		vyp
0b00000001	0x01	vyp		vyp		vyp		zap
------------------------------------------------
*/

/* hlavickovy subor support_common.h obsahuje (okrem ineho):
   -> Deklaracie I/O registrov
   -> Definicie systemovych nastaveni (Frekvencia systemovej zbernice, 
                                       Baudrate UARTu)
   -> Deklaracie funkcii potrebnych pre inicialiaciu procesoru, PLL, UARTu... */
#include "support_common.h"

/* nasleduje:
   -> re-deklaracie pouzivanych I/O registrov pre lepsiu zrozumitelnost kodu
   -> definicie konstant pre zvysenu "cistotu" a pohodlnu editaciu kodu    */
/* MCF_GPIO_PORTTC je deklaracia registra v I/O prestore,urceneho pre fyzicky 
   vystup dat,PORT je oznaceny TC pretoze alternativna funkcia I/O pinov spociva
   v spolupraci s Citacom/Casovacom (TC=Timer,Counter). Tieto piny je mozne
   pouzit (okrem rozsvecovan+a LED) ako vstup hodinovych impulzov pre TC, ako
   vystup PWM modulacie...(niektore MCU maju tieto porty cislovane, napr x51) */
#define LED_PORT	MCF_GPIO_PORTTC			// port, kde su pripojene LED
/* MCF_GPIO_DDRTC je deklaracia registra v I/O prestore, ktory urcuje smer  
   vystupnych dat; ak bit = 0 -> prislusny pin je nastaveny ako vstup; 
                   ak bit = 1 -> prislusny pin je nastaveny ako vystup   */
#define LED_DDR     MCF_GPIO_DDRTC          // smer portu pre LED (vstup/vystup)
// naseduju masky pre prislusne bity/piny napr pre LED2 = 0b00000010 = 0x02
#define LED1    	MCF_GPIO_PORTTC_PORTTC0 // maska pre LED1 (LED1=0x01) bit 0
#define LED2    	MCF_GPIO_PORTTC_PORTTC1 // maska pre LED2 (LED2=0x02) bit 1
#define LED3        MCF_GPIO_PORTTC_PORTTC2 // maska pre LED3 (LED3=0x04) bit 2
#define LED4        MCF_GPIO_PORTTC_PORTTC3 // maska pre LED4 (LED3=0x08) bit 3
// nastavenie casoveho oneskorenia medzi prebliknutim LED v mikrosekundach
#define DELAY		75000					// oneskorenie v us

/******************************************************************************\
*
* Funkcia:   cpu_pause
* Popis:	 Funkcia vytvori pauzu na zadany pocet mikrosekund
* Vstup:	 int usecs: doba pauzy v mikrosekundach
* Vystup:	 void
* HW Naroky: DTIM3 (DMA Timer 3)
*
\******************************************************************************/
void cpu_pause(int usecs){
  // Inicializacia DMA Timer 3 
  // MCF_DTIM3_DTRR = DMA Timer Reference Register
  MCF_DTIM3_DTRR = (vuint32)(usecs-1); /* refernecna hodnota pre porovnavannie; 
                                          bude porovnavana s aktualnym stavom 
                                          DTIM3                               */
  // MCF_DTIM3_DTER = DMA Timer Event Registers
  MCF_DTIM3_DTER = MCF_DTIM_DTER_REF;  /* citlivost na udalost zhody referencnej 
                                          a napocitanej hodnoty v DTIM3       */
  // MCF_DTIM3_DTMR = DMA Timer Mode Registers
  MCF_DTIM3_DTMR = 0
    | MCF_DTIM_DTMR_PS(SYSTEM_CLOCK)   // nastavenie preddelicky:podla parametru
    | MCF_DTIM_DTMR_ORRI			   /* povolenie prerusenia pre udalost zhody 
                                          ref. a napocitanej hodnoty v DTIM3  */
    | MCF_DTIM_DTMR_FRR				   /* reset casovaca akonahle dosiahne 
                                          referencnu uroven */
    | MCF_DTIM_DTMR_CLK_DIV1		   // vstupne hodiny DTIM3 = SYSTEM_CLOCK/1
    | MCF_DTIM_DTMR_RST;			   // povolenie casovaca	
  
  //pokial nebude dosiahnuta referencna hodnota v DTIM3...
  while ((MCF_DTIM3_DTER & MCF_DTIM_DTER_REF) == 0) 
  {};				                   //...nerob nic a cakaj
  
  //vypnutie DMA Timer 3  
  MCF_DTIM3_DTMR = 0;
}

/******************************************************************************\
*
* Funkcia:   main
* Popis:	 Funckia Main, tu sa zacina vykonavanie uzivatelskeho programu
*            bezprostredne po inicializacii procesora a niektorych periferii
*            v ramci startovacieho kodu
* Vstup:	 ziaden
* Vystup:	 int implicitne 0 (funkcia sa nikdy nekonci, v principe moze byt 
*            navratova hodnota typu void, teda ziadna)
*
\******************************************************************************/
int main(void){
  //inicializacia registrov pre ovladanie LED 
  LED_PORT = 0x00;	                      // vsetky LED vypnut
  LED_DDR  = (LED1 | LED2 | LED3 | LED4); // nastavit piny pre LED ako vystupne
  MCF_GPIO_PTCPAR = 0x00;				  // nastavit multiplexer pinov na GPIO
  										  // piny mozu sluzit alternat.funkciam
  
  //nekonecna slucka bezne pouzivana pre "embedded" programy
  while(1) {
    //pohyb svietiaceho bodu od LED1 k LED4; medzi prebliknutim je pauza
	for (LED_PORT = LED1; LED_PORT != LED4; LED_PORT <<= 1) 
	  cpu_pause(DELAY);	
	//pohyb svietiaceho bodu od LED4 k LED1; medzi prebliknutim je pauza
	for (LED_PORT = LED4; LED_PORT != LED1; LED_PORT >>= 1)
	  cpu_pause(DELAY);
  }
  return 0;	/* sem sa funckia main nikdy nedostane, no pretoze main ma navrtovu
               hodnotu definovanu ako int, je vhodne pre poriadok kodu a "koser"
               C - programovanie doplnit navrat, pretoze ho kompilator moze
               ocakavat.   */
}